/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.groups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.ui.fields.ComboField;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.StringButtonField;
import org.eclipse.sphinx.platform.ui.fields.StringField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.xtendxpand.XpandEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.typesystem.Type;

public class TemplateGroup
extends AbstractGroup {
    protected static final String CODE_GEN_SECTION = String.valueOf(org.eclipse.sphinx.xtendxpand.ui.internal.Activator.getPlugin().getSymbolicName()) + ".CODE_GEN_SECTION";
    protected static final String STORE_TEMPLATE_FILE = "TEMPLATE_FILE$";
    protected static final String STORE_SELECTED_DEFINITION = "SELECTED_DEFINITION";
    protected StringButtonField templateFileField;
    protected ComboField definitionField;
    protected StringField definitionNameField;
    protected EObject modelObject;
    protected TypeSystem typeSystem;
    private List<AbstractDefinition> definitions;

    public TemplateGroup(String groupName, EObject modelObject, TypeSystem typeSystem) {
        this(groupName, modelObject, typeSystem, null);
    }

    public TemplateGroup(String groupName, EObject modelObject, TypeSystem typeSystem, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
        Assert.isNotNull((Object)typeSystem);
        this.modelObject = modelObject;
        this.typeSystem = typeSystem;
    }

    protected void doCreateContent(final Composite parent, int numColumns) {
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        this.templateFileField = new StringButtonField(new IButtonAdapter(){

            public void changeControlPressed(IField field) {
                IFile file;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.label_templateSelection);
                dialog.setMessage(Messages.msg_chooseTemplate);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                IFile modelFile = EcorePlatformUtil.getFile((EObject)TemplateGroup.this.modelObject);
                if (modelFile != null) {
                    dialog.setInitialSelection((Object)modelFile.getProject());
                }
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            return "xpt".equals(((IFile)element).getFileExtension());
                        }
                        if (element instanceof IResource) {
                            return !ExtendedPlatform.isPlatformPrivateResource((IResource)((IResource)element));
                        }
                        return true;
                    }
                });
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        IFile selectedFile;
                        int nSelected = selection.length;
                        String pluginId = org.eclipse.sphinx.xtendxpand.ui.internal.Activator.getPlugin().getSymbolicName();
                        if (nSelected == 1 && selection[0] instanceof IFile && (selectedFile = (IFile)selection[0]).exists() && "xpt".equals(selectedFile.getFileExtension())) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, pluginId, 4, Messages.msg_chooseTemplateError, null);
                    }
                });
                if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
                    TemplateGroup.this.templateFileField.setText(file.getFullPath().makeRelative().toString());
                    TemplateGroup.this.updateDefinitionFieldItems(file);
                }
            }
        });
        this.templateFileField.setButtonLabel(Messages.label_browse);
        this.templateFileField.setLabelText(Messages.label_templateFile);
        this.templateFileField.fillIntoGrid(parent, numColumns);
        this.templateFileField.addFieldListener(new IFieldListener(){

            public void dialogFieldChanged(IField field) {
                TemplateGroup.this.updateDefinitionFieldItems(TemplateGroup.this.getFile(TemplateGroup.this.templateFileField.getText()));
                TemplateGroup.this.updateDefinitionNameField();
                TemplateGroup.this.notifyGroupChanged((IField)TemplateGroup.this.templateFileField);
            }
        });
        this.definitionField = new ComboField(true);
        this.definitionField.setLabelText(Messages.label_definition);
        this.definitionField.fillIntoGrid(parent, numColumns);
        this.definitionField.addFieldListener(new IFieldListener(){

            public void dialogFieldChanged(IField field) {
                TemplateGroup.this.updateDefinitionNameField();
                TemplateGroup.this.notifyGroupChanged((IField)TemplateGroup.this.templateFileField);
            }
        });
        this.definitionNameField = new StringField();
        this.definitionNameField.setLabelText(Messages.label_definitionName);
        this.definitionNameField.setEditable(false);
        this.definitionNameField.fillIntoGrid(parent, numColumns);
    }

    public void updateDefinitionFieldItems(IFile templateFile) {
        Template template = this.loadTemplate(templateFile);
        if (template != null) {
            this.definitions = Arrays.asList(template.getAllDefinitions());
            this.definitionField.setItems(this.createDefinitionFieldItems(this.definitions));
            return;
        }
        this.definitionField.setItems(new String[0]);
    }

    protected String[] createDefinitionFieldItems(List<AbstractDefinition> definitions) {
        ArrayList<String> result = new ArrayList<String>();
        Type type = this.typeSystem.getType((Object)this.modelObject);
        if (type != null) {
            for (AbstractDefinition definition : definitions) {
                if (!type.getName().equals(definition.getTargetType()) && !this.getSimpleTypeName(type).equals(definition.getTargetType())) continue;
                result.add(definition.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected String getSimpleTypeName(Type type) {
        String typeName = type.getName();
        int idx = typeName.lastIndexOf("::");
        return idx != -1 && typeName.length() >= idx + "::".length() ? typeName.substring(idx + "::".length()) : typeName;
    }

    public String getDefinitionName() {
        String selectedDefinitionName = this.getSelectedDefinitionFieldItem();
        if (selectedDefinitionName != null) {
            return XtendXpandUtil.getQualifiedName((IFile)this.getFile(this.getTemplateFileField().getText()), (String)selectedDefinitionName);
        }
        return "";
    }

    protected void updateDefinitionNameField() {
        IFile templateFile = this.getFile(this.templateFileField.getText());
        if (templateFile != null) {
            this.definitionNameField.setText(this.getDefinitionName());
        } else {
            this.definitionNameField.setText("...");
        }
    }

    protected Template loadTemplate(IFile templateFile) {
        IXtendXpandResource resource;
        IXtendXpandProject project;
        if (templateFile != null && templateFile.exists() && "xpt".equals(templateFile.getFileExtension()) && (project = Activator.getExtXptModelManager().findProject((IResource)templateFile)) != null && (resource = project.findXtendXpandResource((IStorage)templateFile)) != null) {
            return (Template)resource.getExtXptResource();
        }
        return null;
    }

    public boolean isGroupComplete() {
        IFile templateFile = this.getFile(this.getTemplateFileField().getText());
        if (templateFile != null) {
            return templateFile.exists() && this.getDefinitionField().getSelectionIndex() != -1;
        }
        return false;
    }

    public IFile getFile(String fullPath) {
        Path path;
        if (fullPath != null && fullPath.length() > 0 && (path = new Path(fullPath)).segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public StringButtonField getTemplateFileField() {
        return this.templateFileField;
    }

    public ComboField getDefinitionField() {
        return this.definitionField;
    }

    public String getSelectedDefinitionFieldItem() {
        if (this.definitionField != null && !this.definitionField.getComboControl().isDisposed()) {
            String[] items = this.definitionField.getItems();
            int selectionIndex = this.definitionField.getSelectionIndex();
            if (items.length > 0 && selectionIndex != -1) {
                return items[selectionIndex];
            }
        }
        return null;
    }

    public StringField getDefinitionNameField() {
        return this.definitionNameField;
    }

    public List<AbstractDefinition> getDefinitions() {
        return this.definitions;
    }

    public Collection<XpandEvaluationRequest> getXpandEvaluationRequests() {
        String definitionName;
        ArrayList<XpandEvaluationRequest> requests = new ArrayList<XpandEvaluationRequest>();
        if (this.modelObject != null && (definitionName = this.getDefinitionName()) != null && definitionName.length() > 0) {
            requests.add(new XpandEvaluationRequest(definitionName, (Object)this.modelObject));
        }
        return requests;
    }

    protected void loadGroupSettings() {
        String templateFile = this.getTemplateFileFromDialogSettings();
        if (templateFile != null) {
            this.templateFileField.setText(templateFile);
            this.updateDefinitionFieldItems(this.getFile(templateFile));
            String definition = this.getDefinitionNameFromDialogSettings();
            if (definition != null) {
                this.definitionField.selectItem(definition);
            }
        }
    }

    public String getTemplateFileFromDialogSettings() {
        IFile templateFile;
        String templateFilePath;
        String result = null;
        String templateFileDialogSettingsKey = this.getTemplateFileDialogSettingsKey(this.modelObject);
        IDialogSettings templateFileSection = this.getTemplateFileSection();
        if (templateFileSection != null && (templateFilePath = templateFileSection.get(templateFileDialogSettingsKey)) != null && (templateFile = this.getFile(templateFilePath)) != null && templateFile.exists()) {
            result = templateFilePath;
        }
        return result;
    }

    public String getDefinitionNameFromDialogSettings() {
        String result = null;
        IDialogSettings templateFileSection = this.getTemplateFileSection();
        if (templateFileSection != null) {
            result = templateFileSection.get(STORE_SELECTED_DEFINITION);
        }
        return result;
    }

    protected IDialogSettings getTemplateFileSection() {
        IDialogSettings section;
        IDialogSettings result = null;
        String templateFileDialogSettingsKey = this.getTemplateFileDialogSettingsKey(this.modelObject);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(CODE_GEN_SECTION)) != null) {
            result = section.getSection(templateFileDialogSettingsKey);
        }
        return result;
    }

    public void saveGroupSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String key = this.getTemplateFileDialogSettingsKey(this.modelObject);
            IDialogSettings topLevelSection = settings.getSection(CODE_GEN_SECTION);
            if (topLevelSection == null) {
                topLevelSection = settings.addNewSection(CODE_GEN_SECTION);
            }
            if (this.templateFileField.getText().trim().length() != 0) {
                IDialogSettings templateFileSection = topLevelSection.getSection(key);
                if (templateFileSection == null) {
                    templateFileSection = topLevelSection.addNewSection(key);
                }
                templateFileSection.put(key, this.templateFileField.getText());
                String[] items = this.definitionField.getItems();
                int selectionIndex = this.definitionField.getSelectionIndex();
                if (items.length > 0 && selectionIndex != -1) {
                    templateFileSection.put(STORE_SELECTED_DEFINITION, items[selectionIndex]);
                }
            }
        }
    }

    protected String getTemplateFileDialogSettingsKey(EObject object) {
        Assert.isNotNull((Object)object);
        return STORE_TEMPLATE_FILE + EcoreResourceUtil.getURI((EObject)object).toString();
    }
}

