/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.edit.LocalProxyChangeListener;
import org.eclipse.sphinx.platform.util.ReflectUtil;

public class ExtendedDeleteAction
extends DeleteAction {
    protected AdapterFactory customAdapterFactory;

    public ExtendedDeleteAction(EditingDomain domain, boolean removeAllReferences, AdapterFactory customAdapterFactory) {
        super(domain, removeAllReferences);
        this.customAdapterFactory = customAdapterFactory;
    }

    public ExtendedDeleteAction(boolean removeAllReferences, AdapterFactory customAdapterFactory) {
        this(null, removeAllReferences, customAdapterFactory);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.domain != null) {
            AdapterFactory oldAdapterFactory = null;
            if (this.customAdapterFactory != null) {
                oldAdapterFactory = ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
                ((AdapterFactoryEditingDomain)this.domain).setAdapterFactory(this.customAdapterFactory);
            }
            boolean result = super.updateSelection(selection);
            if (oldAdapterFactory != null) {
                ((AdapterFactoryEditingDomain)this.domain).setAdapterFactory(oldAdapterFactory);
            }
            return result;
        }
        return false;
    }

    public Command createCommand(Collection<?> selection) {
        if (this.supportsProxyficationOfRemovedElements(this.domain)) {
            this.removeAllReferences = false;
        }
        return super.createCommand(selection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean supportsProxyficationOfRemovedElements(EditingDomain domain) {
        if (!(domain instanceof TransactionalEditingDomain)) return false;
        try {
            ResourceSetListener[] listeners;
            ResourceSetListener[] resourceSetListenerArray = listeners = (ResourceSetListener[])ReflectUtil.invokeInvisibleMethod((Object)domain, (String)"getPostcommitListeners", (Object[])new Object[0]);
            int n = listeners.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ResourceSetListener listner = resourceSetListenerArray[n2];
                if (listner instanceof LocalProxyChangeListener) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

