/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptActionHandler;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptConditionHandler;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private Logger logger = LoggerFactory.getLogger(ScriptModuleHandlerFactory.class);
    private ScriptEngineManager scriptEngineManager;
    private static final Collection<String> types = Arrays.asList("script.ScriptAction", "script.ScriptCondition");

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    public Collection<String> getTypes() {
        return types;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void unsetScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = null;
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        String moduleTypeUID = module.getTypeUID();
        if (moduleTypeUID != null) {
            if ("script.ScriptCondition".equals(moduleTypeUID) && module instanceof Condition) {
                ScriptConditionHandler handler = new ScriptConditionHandler((Condition)module, ruleUID, this.scriptEngineManager);
                return handler;
            }
            if ("script.ScriptAction".equals(moduleTypeUID) && module instanceof Action) {
                ScriptActionHandler handler = new ScriptActionHandler((Action)module, ruleUID, this.scriptEngineManager);
                return handler;
            }
            this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        } else {
            this.logger.error("ModuleType is not registered: {}", (Object)moduleTypeUID);
        }
        return null;
    }
}

