/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script;

import com.google.inject.Binder;
import com.google.inject.Module;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.engine.IActionServiceProvider;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.internal.engine.ServiceTrackerActionServiceProvider;
import org.eclipse.smarthome.model.script.script.Script;
import org.eclipse.smarthome.model.script.script.impl.ScriptImpl;

public class ServiceModule
implements Module {
    private final ScriptServiceUtil scriptServiceUtil;
    private final ScriptEngine scriptEngine;

    public ServiceModule(ScriptServiceUtil scriptServiceUtil, ScriptEngine scriptEngine) {
        this.scriptServiceUtil = scriptServiceUtil;
        this.scriptEngine = scriptEngine;
    }

    public void configure(Binder binder) {
        binder.bind(ItemRegistry.class).toInstance((Object)this.scriptServiceUtil.getItemRegistryInstance());
        binder.bind(ThingRegistry.class).toInstance((Object)this.scriptServiceUtil.getThingRegistryInstance());
        binder.bind(ModelRepository.class).toInstance((Object)this.scriptServiceUtil.getModelRepositoryInstance());
        binder.bind(ScriptEngine.class).toInstance((Object)this.scriptEngine);
        binder.bind(IActionServiceProvider.class).toInstance((Object)new ServiceTrackerActionServiceProvider(this.scriptServiceUtil));
        binder.bind(Script.class).to(ScriptImpl.class);
    }
}

