/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditorOperation;

public class RemoveColumnOperation
extends EditorOperation {
    private final ColumnInfo column;
    private final int columnIndex;
    private final int columnWidth;
    boolean changedColumn = false;

    public RemoveColumnOperation(String string, StringEditorPart stringEditorPart, ColumnInfo columnInfo, int n, int n2) {
        super(string, stringEditorPart);
        this.column = columnInfo;
        this.columnIndex = n;
        this.columnWidth = n2;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().removeColumn(this.column.getId());
        this.changedColumn = this.getEditor().unmarkColumnAsChanged(this.column.getId());
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().addColumn(this.column, this.columnIndex).setWidth(this.columnWidth);
        if (this.changedColumn) {
            this.getEditor().markColumnAsChanged(this.column.getId());
        }
        return Status.OK_STATUS;
    }
}

