/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditorOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveKeyOperation
extends EditorOperation {
    private final List<RowInfo> rows;

    public RemoveKeyOperation(String string, StringEditorPart stringEditorPart, List<RowInfo> list) {
        super(string, stringEditorPart);
        this.rows = list;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (RowInfo rowInfo : this.rows) {
            this.getEditor().removeRow(rowInfo.getKey());
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (RowInfo rowInfo : this.rows) {
            this.getEditor().addRow(rowInfo);
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }
}

