/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.wizard.ui;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.wizard.DeviceWizardResources;
import org.eclipse.tml.framework.device.wizard.model.IWizardProjectPage;

public class WizardNewProjectPage
extends WizardPage
implements IWizardProjectPage {
    private static final String INSTANCE_NAME = "instance name";
    private static final int SIZING_HOST_FIELD_WIDTH = 250;
    private String initialProjectName = "";
    private String projectName;
    private Text projectNameField;

    public WizardNewProjectPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    private final void createPropertyGroup(Composite parent) {
        Composite propertyGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        propertyGroup.setLayout((Layout)layout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        Label projectNameLabel = new Label(propertyGroup, 0);
        projectNameLabel.setText(INSTANCE_NAME);
        projectNameLabel.setFont(parent.getFont());
        this.projectNameField = new Text(propertyGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectName != null) {
            this.projectNameField.setText(this.initialProjectName);
        }
        this.projectNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                boolean valid = WizardNewProjectPage.this.validatePage();
                WizardNewProjectPage.this.setPageComplete(valid);
            }
        });
    }

    protected boolean validatePage() {
        InstanceManager manager = InstanceManager.getInstance();
        String name = this.projectNameField.getText();
        String errorMessage = null;
        boolean retVal = false;
        if (name != null && !(name = name.trim()).equals("")) {
            if (manager.getInstancesByname(name).size() == 0) {
                retVal = true;
            } else {
                errorMessage = DeviceWizardResources.TML_Emulator_Wizard_Project_Description_Duplicated_Error;
            }
        }
        this.setErrorMessage(errorMessage);
        return retVal;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createPropertyGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectName;
        }
        this.projectName = this.projectNameField.getText().trim();
        return this.projectName;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }
}

