/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.AbstractServiceCallbackAssociator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.ICallbackRegistrar;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.IImportableServiceCallbackAssociator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

@Component(immediate=true)
public class ImportableServiceCallbackAssociator
extends AbstractServiceCallbackAssociator
implements RemoteServiceAdminListener,
IImportableServiceCallbackAssociator {
    protected Map<Class<?>, ExportableCallback> serviceCallbackMap = new HashMap();

    @Override
    @Reference
    protected void bindContainerManager(IContainerManager cm) {
        super.bindContainerManager(cm);
    }

    @Override
    protected void unbindContainerManager(IContainerManager cm) {
        super.unbindContainerManager(cm);
    }

    @Override
    @Reference
    protected void bindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        super.bindRemoteServiceAdmin(rsa);
    }

    @Override
    protected void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        super.unbindRemoteServiceAdmin(rsa);
    }

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        super.activate(bundleContext);
        this.serviceCallbackMap = new HashMap();
    }

    @Override
    @Deactivate
    protected void deactivate() {
        if (this.serviceCallbackMap != null) {
            this.serviceCallbackMap.clear();
            this.serviceCallbackMap = null;
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICallbackRegistrar associateCallbackRegistrar(Class<?> importedServiceClass, ICallbackRegistrar callbackRegistrar) {
        if (importedServiceClass == null || callbackRegistrar == null) {
            throw new NullPointerException("Service and registrar must both be non-null");
        }
        ExportableCallback ec = null;
        Map<Class<?>, ExportableCallback> map = this.serviceCallbackMap;
        synchronized (map) {
            ec = this.serviceCallbackMap.put(importedServiceClass, new ExportableCallback(callbackRegistrar));
        }
        return ec == null ? null : ec.callbackRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICallbackRegistrar getAssociatedRegistrar(Class<?> importedServiceClass) {
        ExportableCallback ec = null;
        Map<Class<?>, ExportableCallback> map = this.serviceCallbackMap;
        synchronized (map) {
            ec = this.serviceCallbackMap.get(importedServiceClass);
        }
        return ec == null ? null : ec.callbackRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICallbackRegistrar unassociateCallbackRegistrar(Class<?> importedServiceClass) {
        ExportableCallback ecb = null;
        Map<Class<?>, ExportableCallback> map = this.serviceCallbackMap;
        synchronized (map) {
            ecb = this.serviceCallbackMap.remove(importedServiceClass);
        }
        if (ecb == null) {
            return null;
        }
        ecb.closeAll();
        return ecb.callbackRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExportableCallback findExportableCallback(List<String> services, List<String> asyncServices) {
        Map<Class<?>, ExportableCallback> map = this.serviceCallbackMap;
        synchronized (map) {
            for (Class<?> c : this.serviceCallbackMap.keySet()) {
                if (!services.contains(c.getName()) && !asyncServices.contains(c.getName())) continue;
                return this.serviceCallbackMap.get(c);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExportableCallback findExportableCallback(RemoteServiceAdmin.ImportReference importRef) {
        Map<Class<?>, ExportableCallback> map = this.serviceCallbackMap;
        synchronized (map) {
            for (ExportableCallback cb : this.serviceCallbackMap.values()) {
                List<ExportRegistration> exportRegs = cb.callbackExportRegs.get(importRef);
                if (exportRegs == null) continue;
                return cb;
            }
        }
        return null;
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        RemoteServiceAdmin.ImportReference importRef;
        int type = event.getType();
        Throwable t = event.getException();
        if (t == null && (importRef = (RemoteServiceAdmin.ImportReference)event.getImportReference()) != null) {
            ExportableCallback cb = null;
            if (type == 1) {
                EndpointDescription ed = (EndpointDescription)importRef.getImportedEndpoint();
                if (ed != null) {
                    cb = this.findExportableCallback(ed.getInterfaces(), ed.getAsyncInterfaces());
                }
            } else if (type == 4) {
                cb = this.findExportableCallback(importRef);
            }
            if (cb != null) {
                if (type == 1) {
                    try {
                        cb.registerAndExportCallback(importRef);
                    }
                    catch (Throwable e) {
                        this.logException("Could not export callback=" + cb, e);
                    }
                } else if (type == 4) {
                    cb.close(importRef);
                }
            }
        }
    }

    protected Map<String, Object> createCallbackExportProperties(EndpointDescription ed, ServiceReference<?> serviceRef) {
        String pkgName;
        String pkgVer;
        ID cID = ed.getContainerID();
        IContainer c = this.getContainerConnectedToID(cID);
        ContainerTypeDescription ctd = this.getContainerTypeDescription(c.getID());
        String containerFactoryId = ctd.getName();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("service.exported.interfaces", "*");
        props.put("ecf.exported.async.interfaces", "*");
        props.put("service.exported.configs", containerFactoryId);
        props.put("ecf.endpoint.connecttarget.id", cID.getName());
        if (c != null) {
            props.put("ecf.endpoint.idfilter.ids", new String[]{c.getID().getName()});
        }
        String endpointid = UUID.randomUUID().toString();
        props.put("endpoint.id", endpointid);
        props.put("ecf.x.rsa.endpoint.id", endpointid);
        String fwuuid = this.getContext().getProperty("org.osgi.framework.uuid");
        if (fwuuid != null) {
            props.put("ecf.x.rsa.endpoint.framework.uuid", fwuuid);
        }
        props.put("ecf.x.rsa.ecf.endpoint.ts", System.currentTimeMillis());
        props.put("ecf.x.rsa.remote.configs.supported", new String[]{containerFactoryId});
        props.put("ecf.x.rsa.remote.intents.supported", ctd.getSupportedIntents());
        props.put("ecf.x.rsa.service.imported.configs", new String[]{containerFactoryId});
        List<String> intfs = Arrays.asList((String[])serviceRef.getProperty("objectClass"));
        Object svc = this.getContext().getService(serviceRef);
        Class<?> clazz = this.findMatchingInterface(intfs, svc.getClass());
        this.getContext().ungetService(serviceRef);
        if (clazz != null && (pkgVer = this.getCallbackPackageVersion(clazz, pkgName = this.getPackageName(clazz.getName()))) != null) {
            props.put("ecf.x.rsa.endpoint.package.version." + pkgName, pkgVer);
        }
        return props;
    }

    protected class ExportableCallback {
        protected ICallbackRegistrar callbackRegistrar;
        protected ServiceRegistration<?> callbackRegistration;
        protected Map<RemoteServiceAdmin.ImportReference, List<ExportRegistration>> callbackExportRegs;

        protected ExportableCallback(ICallbackRegistrar registrar) {
            this.callbackRegistrar = registrar;
            this.callbackRegistration = null;
            this.callbackExportRegs = Collections.synchronizedMap(new HashMap());
        }

        protected boolean registerAndExportCallback(RemoteServiceAdmin.ImportReference importedServiceRef) throws Throwable {
            if (importedServiceRef == null) {
                return false;
            }
            EndpointDescription ed = (EndpointDescription)importedServiceRef.getImportedEndpoint();
            if (ed == null) {
                return false;
            }
            List<ExportRegistration> exportRegistrations = null;
            exportRegistrations = this.callbackExportRegs.get(importedServiceRef);
            if (exportRegistrations != null) {
                return false;
            }
            this.callbackRegistration = this.callbackRegistrar.registerCallback(importedServiceRef);
            if (this.callbackRegistration == null) {
                throw new NullPointerException("Callback registration cannot be null");
            }
            ServiceReference callbackRef = this.callbackRegistration.getReference();
            exportRegistrations = new ArrayList<ExportRegistration>();
            try {
                ExportRegistration exportReg;
                Map<String, Object> properties = ImportableServiceCallbackAssociator.this.createCallbackExportProperties(ed, this.callbackRegistration.getReference());
                Collection exportRegs = ImportableServiceCallbackAssociator.this.getRSA().exportService(callbackRef, properties);
                if (exportRegs.size() > 0 && (exportReg = (ExportRegistration)exportRegs.iterator().next()) != null) {
                    Throwable t = exportReg.getException();
                    if (t != null) {
                        throw t;
                    }
                    exportRegistrations.add(exportReg);
                }
                if (exportRegistrations.size() > 0) {
                    this.callbackExportRegs.put(importedServiceRef, exportRegistrations);
                }
                return true;
            }
            catch (Throwable e) {
                ImportableServiceCallbackAssociator.this.logException("Could not export callback serviceRef=" + callbackRef, e);
                this.callbackRegistration.unregister();
                this.callbackRegistration = null;
                throw e;
            }
        }

        protected void closeRegistrations(List<ExportRegistration> eRegs) {
            if (eRegs != null) {
                for (ExportRegistration er : eRegs) {
                    try {
                        er.close();
                    }
                    catch (Exception e) {
                        ImportableServiceCallbackAssociator.this.logException("Could not close export registration=" + er, e);
                    }
                }
            }
        }

        protected void close(RemoteServiceAdmin.ImportReference importReference) {
            List<ExportRegistration> exportRegs = this.callbackExportRegs.remove(importReference);
            if (exportRegs != null) {
                this.closeRegistrations(exportRegs);
            }
            if (this.callbackExportRegs.size() == 0 && this.callbackRegistration != null) {
                try {
                    this.callbackRegistration.unregister();
                }
                catch (Exception e) {
                    ImportableServiceCallbackAssociator.this.logException("Exception unregistering callback", e);
                }
                this.callbackRegistration = null;
            }
        }

        protected void closeAll() {
            HashSet<RemoteServiceAdmin.ImportReference> keys = new HashSet<RemoteServiceAdmin.ImportReference>(this.callbackExportRegs.keySet());
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                this.close((RemoteServiceAdmin.ImportReference)i.next());
            }
        }
    }
}

