/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.ui.internal.UILockListener;

public final class PendingSyncExec {
    private final Semaphore semaphore = new Semaphore(0);
    private Thread operation;
    private final Runnable runnable;
    private boolean hasFinishedRunning;

    public PendingSyncExec(Runnable runnable) {
        this.runnable = runnable;
    }

    private boolean acquire(long delay) throws InterruptedException {
        return this.semaphore.tryAcquire(delay, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object obj) {
        return this.runnable == ((PendingSyncExec)obj).runnable;
    }

    public Thread getOperationThread() {
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.interrupted();
        try {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }
        catch (Throwable throwable) {
            PendingSyncExec pendingSyncExec = this;
            synchronized (pendingSyncExec) {
                this.hasFinishedRunning = true;
            }
            Thread.interrupted();
            this.semaphore.release();
            throw throwable;
        }
        PendingSyncExec pendingSyncExec = this;
        synchronized (pendingSyncExec) {
            this.hasFinishedRunning = true;
        }
        Thread.interrupted();
        this.semaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilExecuted(UILockListener lockListener) throws InterruptedException {
        while (!this.acquire(1000L)) {
            if (!lockListener.isUIWaiting()) continue;
            PendingSyncExec pendingSyncExec = this;
            synchronized (pendingSyncExec) {
                if (!this.hasFinishedRunning) {
                    lockListener.interruptUI(this.runnable);
                }
            }
        }
    }

    public int hashCode() {
        return this.runnable == null ? 0 : this.runnable.hashCode();
    }

    public void setOperationThread(Thread operation) {
        this.operation = operation;
    }

    public String toString() {
        return "PendingSyncExec(" + this.runnable + ")";
    }
}

