/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.Base64;
import org.eclipse.packagedrone.repo.utils.Tokens;

public class Users {
    public static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(String.format("Message digest could not be created: SHA-256", new Object[0]));
        }
    }

    public static String hashIt(String salt, String data) {
        data = Normalizer.normalize(data, Normalizer.Form.NFC);
        byte[] strData = data.getBytes(StandardCharsets.UTF_8);
        byte[] saltData = salt.getBytes(StandardCharsets.UTF_8);
        byte[] first = new byte[saltData.length + strData.length];
        System.arraycopy(saltData, 0, first, 0, saltData.length);
        System.arraycopy(strData, 0, first, saltData.length, strData.length);
        MessageDigest md = Users.createDigest();
        byte[] digest = md.digest(first);
        byte[] current = new byte[saltData.length + digest.length];
        int i = 0;
        while (i < 1000) {
            System.arraycopy(saltData, 0, current, 0, saltData.length);
            System.arraycopy(digest, 0, current, saltData.length, digest.length);
            digest = md.digest(current);
            ++i;
        }
        return Base64.getEncoder().encodeToString(digest);
    }

    public static String createToken(int size) {
        return Tokens.createToken((int)size);
    }
}

