/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.mail.java;

import com.google.common.io.CharStreams;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.packagedrone.mail.MailService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailService
implements MailService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMailService.class);
    public static final String PROPERTY_PREFIX = "properties.";
    public static final String SERVICE_PID = "org.eclipse.packagedrone.mail.default";
    private Session session;
    private Dictionary<String, Object> config;

    public void updated(ComponentContext context) {
        this.stop();
        this.start(context);
    }

    public void start(ComponentContext context) {
        this.config = context.getProperties();
        final String username = this.getString("username");
        final String password = this.getString("password");
        Properties properties = new Properties();
        Enumeration<String> keys = this.config.keys();
        while (keys.hasMoreElements()) {
            Object val;
            String key = keys.nextElement();
            logger.debug("Checking key: {}", (Object)key);
            if (!key.startsWith(PROPERTY_PREFIX) || (val = this.config.get(key)) == null) continue;
            String mkey = key.substring(PROPERTY_PREFIX.length());
            logger.info("Property - {} = {}", (Object)mkey, val);
            properties.put(mkey, val);
        }
        Authenticator auth = null;
        if (username != null && password != null) {
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
            properties.put("mail.smtp.auth", "true");
        }
        this.session = Session.getInstance((Properties)properties, auth);
    }

    private String getString(String key) {
        Object val = this.config.get(key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public void stop() {
        this.session = null;
    }

    @Override
    public void sendMessage(String to, String subject, Readable readable) throws Exception {
        Message message = this.createMessage(to, subject);
        message.setText(CharStreams.toString((Readable)readable));
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(String to, String subject, String text, String html) throws Exception {
        Message message = this.createMessage(to, subject);
        if (html != null && !html.isEmpty()) {
            MimeMultipart parts = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(text, "UTF-8");
            parts.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)html, "text/html; charset=utf-8");
            parts.addBodyPart((BodyPart)htmlPart);
            message.setContent((Multipart)parts);
        } else {
            message.setText(text);
        }
        this.sendMessage(message);
    }

    private void sendMessage(Message message) throws MessagingException, NoSuchProviderException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            message.saveChanges();
            transport.connect();
            try (Transport transport = this.session.getTransport();){
                transport.sendMessage(message, message.getAllRecipients());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Message createMessage(String to, String subject) throws MessagingException, AddressException {
        MimeMessage message = new MimeMessage(this.session);
        String from = this.getString("from");
        if (from != null) {
            message.setFrom((Address)new InternetAddress(from));
        } else {
            message.setFrom();
        }
        InternetAddress recipient = new InternetAddress();
        recipient.setAddress(to);
        message.setRecipient(Message.RecipientType.TO, (Address)recipient);
        String prefix = this.getString("prefix");
        if (prefix != null) {
            message.setSubject(String.valueOf(prefix) + " " + subject);
        } else {
            message.setSubject(subject);
        }
        message.setHeader("Return-Path", "<>");
        return message;
    }
}

