/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal.internal.jsp;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.jsp.jasper.JspServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspBundle {
    private static final Logger logger = LoggerFactory.getLogger(JspBundle.class);
    private final String alias;
    private final JspServlet servlet;
    private final HttpService service;

    public JspBundle(Bundle bundle, HttpService service, HttpContext context) throws ServletException, NamespaceException {
        this.service = service;
        this.alias = String.format("/bundle/%s/WEB-INF", bundle.getBundleId());
        this.servlet = new JspServlet(bundle, "/WEB-INF", this.alias);
        logger.info("Registering JSP servlet - resources: /WEB-INF, alias: {}, bundle: {}", (Object)this.alias, (Object)bundle.getSymbolicName());
        Hashtable<String, String> initparams = new Hashtable<String, String>(2);
        ((Dictionary)initparams).put("compilerSourceVM", "1.8");
        ((Dictionary)initparams).put("compilerTargetVM", "1.8");
        this.service.registerServlet(this.alias, (Servlet)this.servlet, initparams, context);
    }

    public void dispose() {
        logger.info("Unregistering JSP servlet - alias: {}", (Object)this.alias);
        this.service.unregister(this.alias);
    }
}

