/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.p2.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.packagedrone.repo.aspect.common.p2.InstallableUnit;
import org.eclipse.packagedrone.repo.aspect.common.p2.P2MetaDataInformation;
import org.eclipse.packagedrone.repo.aspect.common.p2.internal.P2Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.osgi.framework.Version;

public class Creator {
    private final Context context;
    private final Supplier<XMLOutputFactory> factoryProvider;

    public Creator(Context context, Supplier<XMLOutputFactory> factoryProvider) {
        this.context = context;
        this.factoryProvider = factoryProvider;
    }

    private void createP2Artifacts(String id, Version version, String type, ArtifactInformation artifact, String contentType) throws Exception {
        String md5 = (String)artifact.getMetaData().get(P2Virtualizer.KEY_MD5);
        this.context.create(this.makeName(artifact, "-p2artifacts.xml"), (IOConsumer<OutputStream>)((IOConsumer)out -> {
            try {
                XMLStreamWriter xsw = this.factoryProvider.get().createXMLStreamWriter((OutputStream)out);
                xsw.writeStartDocument();
                xsw.writeStartElement("artifacts");
                xsw.writeAttribute("size", "1");
                xsw.writeStartElement("artifact");
                xsw.writeAttribute("classifier", type);
                xsw.writeAttribute("id", id);
                xsw.writeAttribute("version", version.toString());
                xsw.writeStartElement("properties");
                int size = 3;
                if (md5 != null) {
                    ++size;
                }
                if (contentType != null) {
                    ++size;
                }
                xsw.writeAttribute("size", Integer.toString(size));
                this.writeProperty(xsw, "download.size", "" + artifact.getSize());
                this.writeProperty(xsw, "artifact.size", "" + artifact.getSize());
                this.writeProperty(xsw, "download.contentType", contentType);
                this.writeProperty(xsw, "drone.artifact.id", artifact.getId());
                this.writeProperty(xsw, "download.md5", md5);
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndDocument();
                xsw.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }));
    }

    private void writeProperty(XMLStreamWriter xsw, String key, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        xsw.writeEmptyElement("property");
        xsw.writeAttribute("name", key);
        xsw.writeAttribute("value", value);
    }

    public void createFeatureP2Artifacts(ArtifactInformation artifact, FeatureInformation fi) throws Exception {
        this.createP2Artifacts(fi.getId(), fi.getVersion(), "org.eclipse.update.feature", artifact, "application/zip");
    }

    public void createBundleP2Artifacts(ArtifactInformation artifact, BundleInformation bi) throws Exception {
        this.createP2Artifacts(bi.getId(), bi.getVersion(), "osgi.bundle", artifact, null);
    }

    public void createFeatureP2MetaData(ArtifactInformation art, FeatureInformation fi) throws Exception {
        List<InstallableUnit> ius = InstallableUnit.fromFeature(fi);
        this.context.create(this.makeName(art, "-p2metadata.xml"), (IOConsumer<OutputStream>)((IOConsumer)out -> {
            try {
                XMLStreamWriter xsw = this.factoryProvider.get().createXMLStreamWriter((OutputStream)out);
                InstallableUnit.writeXml(xsw, ius);
                xsw.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }));
    }

    public void createBundleP2MetaData(P2MetaDataInformation info, ArtifactInformation art, BundleInformation bi) throws Exception {
        this.context.create(this.makeName(art, "-p2metadata.xml"), (IOConsumer<OutputStream>)((IOConsumer)out -> {
            try {
                XMLStreamWriter xsw = this.factoryProvider.get().createXMLStreamWriter((OutputStream)out);
                InstallableUnit.fromBundle(bi, info).writeXml(xsw);
                xsw.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }));
    }

    private String makeName(ArtifactInformation art, String suffix) {
        String name = art.getName();
        name = name.replaceFirst("\\.jar$", suffix);
        return name;
    }

    public static interface Context {
        public void create(String var1, IOConsumer<OutputStream> var2) throws IOException;
    }
}

