/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.utils.HashHelper;

public class HashAspectFactory
implements ChannelAspectFactory {
    private static final Map<String, HashFunction> functions = new HashMap<String, HashFunction>();
    private static final String ID = "hasher";
    private static final MetaKey KEY_FILE_TYPE = new MetaKey("hasher", "checksum-file");

    static {
        functions.put("md5", Hashing.md5());
        functions.put("sha1", Hashing.sha1());
        functions.put("sha256", Hashing.sha256());
        functions.put("sha512", Hashing.sha512());
    }

    public ChannelAspect createAspect() {
        return new ChannelAspectImpl();
    }

    private static void makeChecksumMetadata(Path file, Map<String, String> metadata) throws IOException {
        Map result = HashHelper.createChecksums((Path)file, functions);
        for (Map.Entry entry : result.entrySet()) {
            metadata.put((String)entry.getKey(), ((HashCode)entry.getValue()).toString());
        }
    }

    private static class ChannelAspectImpl
    implements ChannelAspect {
        private ChannelAspectImpl() {
        }

        public Extractor getExtractor() {
            return new Extractor(){

                public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
                    HashAspectFactory.makeChecksumMetadata(context.getPath(), metadata);
                }
            };
        }

        public Virtualizer getArtifactVirtualizer() {
            return null;
        }

        public String getId() {
            return HashAspectFactory.ID;
        }
    }

    public static class VirtualizerImpl
    implements Virtualizer {
        private static final MetaKey KEY_MD5 = new MetaKey("hasher", "md5");

        public void virtualize(Virtualizer.Context context) {
            Map md = context.getArtifactInformation().getMetaData();
            if (md.containsKey(KEY_FILE_TYPE)) {
                return;
            }
            String md5 = (String)md.get(KEY_MD5);
            if (md5 != null) {
                HashMap<MetaKey, String> metadata = new HashMap<MetaKey, String>();
                metadata.put(KEY_FILE_TYPE, "md5");
                context.createVirtualArtifact(String.valueOf(context.getArtifactInformation().getName()) + ".md5", out -> out.write(md5.getBytes(StandardCharsets.UTF_8)), metadata);
            }
        }
    }
}

