/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.menu;

import com.google.common.html.HtmlEscapers;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.ButtonFunction;
import org.eclipse.packagedrone.web.common.menu.FunctionalButton;
import org.eclipse.packagedrone.web.common.menu.Modal;

public class MenuEntry
implements Comparable<MenuEntry> {
    private String category;
    private String label;
    private LinkTarget target;
    private Modifier modifier;
    private int categoryOrder;
    private int entryOrder;
    private boolean newWindow;
    private String icon;
    private Modal modal;
    private long badge;

    public MenuEntry(String category, int categoryOrder, String label, int entryOrder, LinkTarget target, Modifier modifier, String icon) {
        this(category, categoryOrder, label, entryOrder, target, modifier, icon, false, 0L);
    }

    public MenuEntry(String category, int categoryOrder, String label, int entryOrder, LinkTarget target, Modifier modifier, String icon, boolean newWindow, long badge) {
        this.category = category;
        this.categoryOrder = category != null ? categoryOrder : entryOrder;
        this.label = label;
        this.entryOrder = category != null ? entryOrder : 0;
        this.target = target;
        this.modifier = modifier;
        this.icon = icon;
        this.newWindow = newWindow;
        this.badge = badge;
    }

    public MenuEntry(String label, int entryOrder, LinkTarget target, Modifier modifier, String icon) {
        this.category = null;
        this.categoryOrder = entryOrder;
        this.label = label;
        this.entryOrder = 0;
        this.target = target;
        this.modifier = modifier;
        this.icon = icon;
        this.newWindow = false;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public String getCategory() {
        return this.category;
    }

    public int getCategoryOrder() {
        return this.categoryOrder;
    }

    public int getEntryOrder() {
        return this.entryOrder;
    }

    public String getLabel() {
        return this.label;
    }

    public LinkTarget getTarget() {
        return this.target;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    protected String getMainLabel() {
        if (this.category != null) {
            return this.category;
        }
        return this.label;
    }

    public MenuEntry setCategory(String category) {
        this.category = category;
        return this;
    }

    public MenuEntry setLabel(String label) {
        this.label = label;
        return this;
    }

    public MenuEntry setTarget(LinkTarget target) {
        this.target = target;
        return this;
    }

    public MenuEntry setModifier(Modifier modifier) {
        this.modifier = modifier;
        return this;
    }

    public MenuEntry setCategoryOrder(int categoryOrder) {
        this.categoryOrder = categoryOrder;
        return this;
    }

    public MenuEntry setEntryOrder(int entryOrder) {
        this.entryOrder = entryOrder;
        return this;
    }

    public MenuEntry setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
        return this;
    }

    public MenuEntry setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public long getBadge() {
        return this.badge;
    }

    public MenuEntry setBadge(long badge) {
        this.badge = badge;
        return this;
    }

    public MenuEntry setModal(Modal modal) {
        this.modal = modal;
        return this;
    }

    public Modal getModal() {
        return this.modal;
    }

    public MenuEntry makeModalMessage(String title, String message) {
        this.modal = new Modal(title, new FunctionalButton(ButtonFunction.CLOSE, "Close"), new FunctionalButton(ButtonFunction.SUBMIT, this.label, this.icon, this.modifier));
        this.modal.setBody("<p>" + HtmlEscapers.htmlEscaper().escape(message) + "</p>");
        return this;
    }

    @Override
    public int compareTo(MenuEntry o) {
        int rc = Integer.compare(this.categoryOrder, o.categoryOrder);
        if (rc != 0) {
            return rc;
        }
        rc = Integer.compare(this.entryOrder, o.entryOrder);
        if (rc != 0) {
            return rc;
        }
        return this.getMainLabel().compareTo(o.getMainLabel());
    }

    public String toString() {
        return String.format("[Menu: %s@%s/%s@%s - %s]", this.category, this.categoryOrder, this.label, this.entryOrder, this.target);
    }
}

