/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.p2.P2ChannelInformation;
import org.eclipse.packagedrone.repo.adapter.p2.aspect.P2RepoConstants;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.AbstractWriter;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactRule;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactStreamer;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactsWriter;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.MetaDataWriter;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.SpoolOutHandler;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelStreamer {
    private static final Logger logger = LoggerFactory.getLogger(ChannelStreamer.class);
    private final boolean writeCompressed;
    private final boolean writePlain;
    private final List<ArtifactRule> rules;
    private final Instant now;
    private final Map<String, String> additionalProperties;
    private final String title;
    private final List<String> artifactsFragments = new LinkedList<String>();
    private long artifactsCounter = 0L;
    private final List<String> metaDataFragments = new LinkedList<String>();
    private long metaDataCounter = 0L;
    private Map<String, String> checksums = new HashMap<String, String>();
    private HashMultimap<String, String> checksumArtifacts = HashMultimap.create();
    private final Set<String> checksumErrors = new HashSet<String>();

    public ChannelStreamer(String title, Map<MetaKey, String> channelMetaData, boolean writeCompressed, boolean writePlain, List<ArtifactRule> rules) {
        this.now = Instant.now();
        this.writeCompressed = writeCompressed;
        this.writePlain = writePlain;
        this.rules = rules;
        this.title = ChannelStreamer.makeTitle(title, channelMetaData);
        this.additionalProperties = new HashMap<String, String>();
        P2ChannelInformation p2ChannelInformation = new P2ChannelInformation();
        try {
            MetaKeys.bind((Object)p2ChannelInformation, channelMetaData);
        }
        catch (Exception exception) {}
        if (p2ChannelInformation.getMirrorsUrl() != null) {
            this.additionalProperties.put("p2.mirrorsURL", p2ChannelInformation.getMirrorsUrl());
        }
        if (p2ChannelInformation.getStatisticsUrl() != null) {
            this.additionalProperties.put("p2.statsURI", p2ChannelInformation.getStatisticsUrl());
        }
    }

    public static String makeTitle(String channelTitle, Map<MetaKey, String> channelMetaData) {
        String title = channelMetaData.get(P2RepoConstants.KEY_REPO_TITLE);
        if (title != null && !title.isEmpty()) {
            return title;
        }
        return String.format("Package Drone Channel: %s", channelTitle);
    }

    public void stream(Collection<ArtifactInformation> artifacts, ArtifactStreamer streamer) {
        this.checksums = new HashMap<String, String>(artifacts.size());
        this.checksumArtifacts = HashMultimap.create((int)artifacts.size(), (int)1);
        for (ArtifactInformation artifact : artifacts) {
            this.process(artifact, streamer);
        }
    }

    public void process(ArtifactInformation artifact, ArtifactStreamer streamer) {
        String type = (String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_TYPE);
        if (type == null) {
            return;
        }
        if ("metadata".equals(type)) {
            this.fastTrackMetaData(artifact, type);
        } else if ("artifacts".equals(type)) {
            this.fastTrackArtifacts(artifact, type);
        }
    }

    private boolean fastTrackArtifacts(ArtifactInformation artifact, String type) {
        String[] data;
        String[] sums;
        String[] keys;
        block9: {
            String sumsString;
            String keysString;
            String dataString;
            block8: {
                dataString = (String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_DATA);
                keysString = (String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_KEYS);
                sumsString = (String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_MD5);
                if (dataString != null && keysString != null && sumsString != null) break block8;
                return false;
            }
            keys = keysString.split(";", -1);
            sums = sumsString.split(";", -1);
            data = dataString.split(";", -1);
            if (keys.length == sums.length && keys.length == data.length) break block9;
            return false;
        }
        try {
            int i = 0;
            while (i < keys.length) {
                String sum = sums[i];
                boolean hasSum = sum != null && !sum.isEmpty();
                String old = hasSum ? this.checksums.put(keys[i], sums[i]) : null;
                if (old == null || old.equals(sums[i])) {
                    ++this.artifactsCounter;
                    this.artifactsFragments.add(data[i]);
                } else {
                    this.checksumErrors.add(keys[i]);
                }
                if (hasSum) {
                    this.checksumArtifacts.put((Object)keys[i], (Object)artifact.getId());
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            logger.info("Failed to process artifact", (Throwable)e);
            return false;
        }
    }

    private boolean fastTrackMetaData(ArtifactInformation artifact, String type) {
        String data;
        int count;
        block3: {
            try {
                count = Integer.parseInt((String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_COUNT));
                data = (String)artifact.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_DATA);
                if (data != null) break block3;
                return false;
            }
            catch (Exception e) {
                logger.info("Failed to process metadat", (Throwable)e);
                return false;
            }
        }
        this.metaDataCounter += (long)count;
        this.metaDataFragments.add(data);
        return true;
    }

    public void spoolOut(SpoolOutHandler handler) throws IOException {
        if (this.writeCompressed) {
            this.spoolOut(handler, new MetaDataWriter(this.metaDataFragments, this.metaDataCounter, this.title, this.now, this.additionalProperties, true));
            this.spoolOut(handler, new ArtifactsWriter(this.artifactsFragments, this.artifactsCounter, this.title, this.now, this.additionalProperties, true, this.rules));
        }
        if (this.writePlain) {
            this.spoolOut(handler, new MetaDataWriter(this.metaDataFragments, this.metaDataCounter, this.title, this.now, this.additionalProperties, false));
            this.spoolOut(handler, new ArtifactsWriter(this.artifactsFragments, this.artifactsCounter, this.title, this.now, this.additionalProperties, false, this.rules));
        }
    }

    private void spoolOut(SpoolOutHandler handler, AbstractWriter writer) throws IOException {
        handler.spoolOut(writer.getId(), writer.getId(), writer.getMimeType(), (IOConsumer<OutputStream>)((IOConsumer)stream -> writer.write((OutputStream)stream)));
    }

    public Map<String, Set<String>> checkDuplicates() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String errorKey : this.checksumErrors) {
            result.put(errorKey, this.checksumArtifacts.get((Object)errorKey));
        }
        return result;
    }
}

