/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class DefaultParameterExtension
extends AbstractSwaggerExtension {
    @Override
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        QueryParameter parameter = null;
        for (Annotation annotation : annotations) {
            Property schema;
            QueryParam param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                QueryParameter qp = (QueryParameter)new QueryParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    qp.setProperty(schema);
                }
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                PathParameter pp = (PathParameter)new PathParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    pp.setProperty(schema);
                }
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                HeaderParameter hp = (HeaderParameter)new HeaderParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    hp.setProperty(schema);
                }
                parameter = hp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                CookieParameter cp = (CookieParameter)new CookieParameter().name(param.value());
                schema = this.createProperty(type);
                if (schema != null) {
                    cp.setProperty(schema);
                }
                parameter = cp;
                continue;
            }
            if (!(annotation instanceof FormParam)) continue;
            param = (FormParam)annotation;
            FormParameter fp = (FormParameter)new FormParameter().name(param.value());
            schema = this.createProperty(type);
            if (schema != null) {
                fp.setProperty(schema);
            }
            parameter = fp;
        }
        if (parameter != null) {
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    @Override
    protected boolean shouldIgnoreClass(Class<?> cls) {
        return cls.getName().startsWith("javax.ws.rs.");
    }

    private Property createProperty(Type type) {
        return this.enforcePrimitive(ModelConverters.getInstance().readAsProperty(type), 0);
    }

    private Property enforcePrimitive(Property in, int level) {
        if (in instanceof RefProperty) {
            return new StringProperty();
        }
        if (in instanceof ArrayProperty) {
            if (level == 0) {
                ArrayProperty array = (ArrayProperty)in;
                array.setItems(this.enforcePrimitive(array.getItems(), level + 1));
            } else {
                return new StringProperty();
            }
        }
        return in;
    }
}

