/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.sitemap;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.packagedrone.repo.web.sitemap.ChangeFrequency;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContext;

public class UrlSetWriter
implements AutoCloseable,
UrlSetContext {
    private static final String NS = "http://www.sitemaps.org/schemas/sitemap/0.9";
    private static final String NL = "\n";
    private static final String IN = "  ";
    private static final String IN2 = "    ";
    private static DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ssXXX", Locale.ROOT);
    private final String urlPrefix;
    private final XMLStreamWriter out;
    private boolean finished;
    private final Writer writer;

    public UrlSetWriter(Writer writer, String urlPrefix, XMLOutputFactory outputFactory) throws IOException {
        this.writer = writer;
        this.urlPrefix = urlPrefix;
        try {
            this.out = outputFactory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.writeStart();
    }

    private void writeEnd() throws IOException {
        try {
            this.out.writeEndElement();
            this.out.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeStart() throws IOException {
        try {
            this.out.writeStartDocument("UTF-8", "1.0");
            this.out.writeCharacters(NL);
            this.out.writeStartElement("urlset");
            this.out.writeDefaultNamespace(NS);
            this.out.writeCharacters(NL);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addLocation(String localUrl, Optional<Instant> lastModification, Optional<ChangeFrequency> changeFrequency, Optional<Double> priority) {
        if (!localUrl.startsWith("/")) {
            localUrl = "/" + localUrl;
        }
        try {
            this.out.writeCharacters(IN);
            this.out.writeStartElement("url");
            this.out.writeCharacters(NL);
            this.writeTag(this.out, "loc", URI.create(String.valueOf(this.urlPrefix) + localUrl).toASCIIString());
            if (lastModification.isPresent()) {
                this.writeTag(this.out, "lastmod", FORMAT.format(lastModification.get().atZone(ZoneId.systemDefault())));
            }
            if (changeFrequency.isPresent()) {
                this.writeTag(this.out, "changefreq", changeFrequency.get().getValue());
            }
            if (priority.isPresent()) {
                double value = Math.min(Math.max(0.0, priority.get()), 1.0);
                this.writeTag(this.out, "priority", String.format("%.1f", value));
            }
            this.out.writeCharacters(IN);
            this.out.writeEndElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(XMLStreamWriter out, String tagName, String value) throws XMLStreamException {
        out.writeCharacters(IN2);
        out.writeStartElement(tagName);
        out.writeCharacters(value);
        out.writeEndElement();
        out.writeCharacters(NL);
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            this.writeEnd();
        }
        try {
            this.out.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.writer.close();
        }
    }
}

