/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.rpm.web.YumConfiguration;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.signing.web.SigningServiceEntry;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@RequestMapping(value={"/ui/yum"})
@ViewResolver(value="/WEB-INF/views/yum/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class YumController {
    private ChannelService service;
    private SitePrefixService sitePrefixService;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public void setSitePrefixService(SitePrefixService sitePrefixService) {
        this.sitePrefixService = sitePrefixService;
    }

    @RequestMapping(value={"/{channelId}/help"})
    public ModelAndView help(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            ModelAndView model = new ModelAndView("help");
            model.put("channel", (Object)channel.getInformation());
            model.put("sitePrefix", (Object)this.sitePrefixService.getSitePrefix());
            return model;
        });
    }

    @RequestMapping(value={"/{channelId}/edit"}, method={RequestMethod.GET})
    public ModelAndView edit(@PathVariable(value="channelId") String id) {
        return Channels.withChannel((ChannelService)this.service, (String)id, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            YumConfiguration cfg = new YumConfiguration();
            MetaKeys.bind((Object)cfg, (Map)channel.getContext().getProvidedMetaData());
            model.put("channel", channel.getInformation());
            model.put("command", cfg);
            model.put("signingServices", SigningServiceEntry.getSigningServices());
            return new ModelAndView("edit", model);
        });
    }

    @RequestMapping(value={"/{channelId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="channelId") String id, @FormData(value="command") @Valid YumConfiguration command, BindingResult result) {
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("signingServices", SigningServiceEntry.getSigningServices());
        if (!result.hasErrors()) {
            return Channels.withChannel((ChannelService)this.service, (String)id, ModifiableChannel.class, channel -> {
                Map metadata = MetaKeys.unbind((Object)command);
                channel.getContext().applyMetaData(metadata);
                model.put("channel", (List)channel.getInformation());
                return new ModelAndView("redirect:edit");
            });
        }
        return Channels.withChannel((ChannelService)this.service, (String)id, ReadableChannel.class, channel -> {
            model.put("channel", (List)channel.getInformation());
            return new ModelAndView("edit", model);
        });
    }
}

