/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.internal.managed;

import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.signing.pgp.ManagedPgpConfiguration;
import org.eclipse.packagedrone.repo.signing.pgp.ManagedPgpFactory;
import org.eclipse.packagedrone.repo.signing.pgp.internal.managed.Configuration;
import org.eclipse.packagedrone.repo.signing.pgp.internal.managed.Entry;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;
import org.eclipse.packagedrone.utils.Locks;
import org.eclipse.packagedrone.utils.Suppressed;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PgpSigningServiceFactory
implements ManagedPgpFactory {
    private StorageManager manager;
    private Path base;
    private Map<String, Entry> entries = new HashMap<String, Entry>();
    private final Lock readLock;
    private final Lock writeLock;
    private final BundleContext context = FrameworkUtil.getBundle(PgpSigningServiceFactory.class).getBundleContext();

    public void setManager(StorageManager manager) {
        this.manager = manager;
    }

    public PgpSigningServiceFactory() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void start() {
        Map<String, Entry> entries;
        this.base = this.manager.getContext().getBasePath();
        Throwable throwable = null;
        Object var3_3 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            entries = this.load();
            this.entries = new HashMap<String, Entry>(entries);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        entries.values().forEach(Entry::start);
    }

    public void stop() {
        ArrayList<Entry> entries;
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            entries = new ArrayList<Entry>(this.entries.values());
            entries.clear();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_4 = null;
        try (Suppressed s = new Suppressed("Failed to stop", RuntimeException::new);){
            for (Entry entry : entries) {
                s.run(entry::stop);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public ManagedPgpConfiguration createService(String label, String key, String passphrase) {
        Entry old;
        Entry entry;
        Throwable throwable = null;
        Object var7_6 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            String id = UUID.randomUUID().toString();
            Configuration cfg = new Configuration();
            cfg.setId(id);
            cfg.setLabel(label);
            cfg.setSecretKey(key);
            cfg.setPassphrase(passphrase);
            entry = new Entry(this.context, cfg);
            old = this.entries.put(id, entry);
            try {
                this.store();
            }
            catch (Exception e) {
                this.entries.remove(id);
                if (old != null) {
                    this.entries.put(id, old);
                }
                throw new RuntimeException(e);
            }
            if (old != null) {
                old.stop();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (old != null) {
            old.stop();
        }
        entry.start();
        return entry.getConfiguration();
    }

    private Path getFile() {
        return this.base.resolve("pgp-keys.json");
    }

    private void store() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(this.getFile(), StandardCharsets.UTF_8);){
            Object[] cfgs = this.entries.values().stream().map(Entry::getRawConfiguration).toArray();
            new GsonBuilder().create().toJson((Object)cfgs, (Appendable)writer);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, Entry> load() {
        HashMap<String, Entry> result = null;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.getFile());){
                Configuration[] cfgs = (Configuration[])new GsonBuilder().create().fromJson((Reader)reader, Configuration[].class);
                result = new HashMap(cfgs.length);
                Configuration[] configurationArray = cfgs;
                int n = cfgs.length;
                int n2 = 0;
                while (n2 < n) {
                    Configuration cfg = configurationArray[n2];
                    Entry entry = new Entry(this.context, cfg);
                    result.put(entry.getRawConfiguration().getId(), entry);
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result != null ? result : new HashMap<String, Entry>();
    }

    @Override
    public void deleteService(String id) {
        Entry entry = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
                entry = this.entries.remove(id);
                try {
                    this.store();
                }
                catch (Exception e) {
                    if (entry != null) {
                        this.entries.put(id, entry);
                        entry = null;
                    }
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (entry != null) {
                entry.stop();
            }
        }
    }

    @Override
    public List<ManagedPgpConfiguration> list(int start, int amount) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            return this.entries.entrySet().stream().map(entry -> ((Entry)entry.getValue()).getConfiguration()).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

