/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.web.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.util.Requests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@RequestMapping(value={"/job"})
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class JobController {
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);
    private JobManager manager;

    public void setManager(JobManager manager) {
        this.manager = manager;
    }

    @RequestMapping(value={"/{factoryId}/create"}, method={RequestMethod.POST})
    @HttpConstraint(rolesAllowed={"MANAGER", "ADMIN"})
    public ModelAndView create(@PathVariable(value="factoryId") String factoryId, @RequestParameter(required=false, value="data") String data) {
        JobHandle job = this.manager.startJob(factoryId, data);
        return new ModelAndView(String.format("redirect:/job/%s/view", job.getId()));
    }

    @RequestMapping(value={"/{id}/view"})
    public ModelAndView view(@PathVariable(value="id") String id) {
        JobHandle job = this.manager.getJob(id);
        HashMap<String, JobHandle> model = new HashMap<String, JobHandle>(1);
        model.put("job", job);
        return new ModelAndView("view", model);
    }

    @RequestMapping(value={"/{id}/monitor"})
    public ModelAndView monitor(@PathVariable(value="id") String id) {
        JobHandle job = this.manager.getJob(id);
        if (job != null) {
            logger.debug("Job: {} - {}", (Object)job.getId(), (Object)job.getState());
        } else {
            logger.debug("No job: {}", (Object)id);
        }
        HashMap<String, JobHandle> model = new HashMap<String, JobHandle>(1);
        model.put("job", job);
        return new ModelAndView("monitor", model);
    }

    @RequestMapping(value={"/{id}/result"})
    public ModelAndView result(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JobHandle job = this.manager.getJob(id);
        if (job == null) {
            return CommonController.createNotFound((String)"job", (String)id);
        }
        if (job != null && job.isComplete() && job.getError() != null) {
            return this.defaultResult(job);
        }
        String factoryId = job.getRequest().getFactoryId();
        JobFactoryDescriptor desc = this.manager.getFactory(factoryId);
        if (desc == null) {
            return this.defaultResult(job);
        }
        LinkTarget target = desc.getResultTarget();
        if (target == null) {
            return this.defaultResult(job);
        }
        LinkTarget url = target.expand(Collections.singletonMap("id", id));
        logger.debug("Forwarding to job result view: {}", (Object)url);
        if (url.getUrl().equals(Requests.getOriginalPath((HttpServletRequest)request))) {
            throw new IllegalStateException(String.format("Illegal redirect to same URL: %s", url.getUrl()));
        }
        RequestDispatcher rd = request.getRequestDispatcher(url.getUrl());
        rd.forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    protected ModelAndView defaultResult(JobHandle job) {
        HashMap<String, JobHandle> model = new HashMap<String, JobHandle>(1);
        model.put("job", job);
        return new ModelAndView("defaultResult", model);
    }
}

