/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.packagedrone.addon.AddonManager;
import org.eclipse.packagedrone.addon.internal.AddonManagerImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private AddonManagerImpl manager;
    private ServiceRegistration<AddonManager> handle;

    public void start(BundleContext context) throws Exception {
        Path path = Activator.initPath(context);
        if (path != null) {
            this.manager = new AddonManagerImpl(path);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.description", "Addon manager");
            ((Dictionary)properties).put("service.vendor", "Eclipse Package Drone");
            this.handle = context.registerService(AddonManager.class, (Object)this.manager, properties);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    private static Path initPath(BundleContext context) {
        try {
            String dir = System.getProperty("package.drone.addons.dir");
            if (dir != null) {
                Path path = Paths.get(dir, new String[0]);
                Files.createDirectories(path, new FileAttribute[0]);
                return path;
            }
            File dataDir = context.getDataFile("addons");
            if (dataDir != null) {
                Files.createDirectories(dataDir.toPath(), new FileAttribute[0]);
                return dataDir.toPath();
            }
            logger.warn("Unable to start addon manager. No base directory available");
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to initialize addons directory", (Throwable)e);
            return null;
        }
    }
}

