/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.packagedrone.addon.Addon;
import org.eclipse.packagedrone.addon.AddonDescription;
import org.eclipse.packagedrone.addon.AddonManager;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.str.Tables;

public class Console {
    private AddonManager addonManager;

    public void setAddonManager(AddonManager addonManager) {
        this.addonManager = addonManager;
    }

    @Descriptor(value="List installed addons")
    public void list() {
        List<Addon> result = this.addonManager.list();
        List<String> header = Arrays.asList("ID", "Name", "Version", "State", "Label", "Error");
        ArrayList data = new ArrayList(result.size());
        for (Addon addon : result) {
            ArrayList<String> row = new ArrayList<String>(6);
            data.add(row);
            row.add(addon.getId());
            row.add(addon.getInformation().getDescription().getId());
            row.add(addon.getInformation().getDescription().getVersion().toString());
            row.add(addon.getInformation().getState().toString());
            row.add(addon.getInformation().getDescription().getLabel());
            if (addon.getInformation().getError() == null) continue;
            row.add(ExceptionHelper.getMessage((Throwable)addon.getInformation().getError()).replace("\n", " ").replace("\r", ""));
        }
        Tables.showTable((PrintStream)System.out, header, data, (int)2);
    }

    @Descriptor(value="Information about an addon")
    public void info(@Descriptor(value="The addon registration id") String addonId) {
        this.withAddon(addonId, addon -> {
            AddonDescription desc = addon.getInformation().getDescription();
            System.out.format("%s (%s:%s)%n", desc.getLabel(), desc.getId(), desc.getVersion());
            System.out.println("=======================================================");
            System.out.format("\tAddon registration: %s%n", addon.getId());
            System.out.format("\tState: %s%n", new Object[]{addon.getInformation().getState()});
            if (addon.getInformation().getStateInformation() != null) {
                System.out.println("-------------------------------------------------------");
                String s = addon.getInformation().getStateInformation();
                while (s.endsWith("\n") || s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                System.out.println(s);
            }
            if (addon.getInformation().getError() != null) {
                System.out.println("-------------------------------------------------------");
                addon.getInformation().getError().printStackTrace(System.out);
            }
            System.out.println("-------------------------------------------------------");
        });
    }

    public void install() {
    }

    @Descriptor(value="Remove an addon from the system")
    public void uninstall(@Descriptor(value="The addon registration id") String addonId) {
        this.withAddon(addonId, Addon::uninstall);
    }

    @Descriptor(value="Enable an addon")
    public void enable(@Descriptor(value="The addon registration id") String addonId) {
        this.withAddon(addonId, Addon::enable);
    }

    @Descriptor(value="Disable an addon")
    public void disable(@Descriptor(value="The addon registration id") String addonId) {
        this.withAddon(addonId, Addon::disable);
    }

    protected void withAddon(String addonId, Consumer<Addon> consumer) {
        Optional<Addon> addon = this.addonManager.getAddon(addonId);
        if (addon.isPresent()) {
            consumer.accept(addon.get());
        } else {
            System.out.format("Unable to find addon: %s%n", addonId);
        }
    }
}

