/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManagerAdapter
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(StorageManagerAdapter.class);
    private final BundleContext context;
    private ServiceRegistration<StorageManager> handle;
    private StorageManager service;

    public StorageManagerAdapter(BundleContext context) {
        this.context = context;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        logger.warn("Updated - properties: {}", properties);
        try {
            this.unregister();
            if (properties != null) {
                String base = (String)properties.get("basePath");
                if (base == null) {
                    throw new ConfigurationException("basePath", "base path is not set");
                }
                Path basePath = Paths.get(base, new String[0]);
                this.register(new StorageManager(basePath));
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("basePath", ExceptionHelper.getMessage((Throwable)e), (Throwable)e);
        }
    }

    private void register(StorageManager storageManager) {
        logger.info("Register service");
        this.service = storageManager;
        Hashtable properties = new Hashtable();
        this.handle = this.context.registerService(StorageManager.class, (Object)storageManager, properties);
    }

    public void dispose() {
        this.unregister();
    }

    private void unregister() {
        if (this.handle != null) {
            logger.info("Unregister service");
            this.handle.unregister();
            this.handle = null;
        }
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
    }
}

