/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import org.eclipse.packagedrone.repo.Version;

public class ChannelAspectInformation {
    public static final Comparator<ChannelAspectInformation> NAME_COMPARATOR = new Comparator<ChannelAspectInformation>(){

        @Override
        public int compare(ChannelAspectInformation o1, ChannelAspectInformation o2) {
            int rc = o1.label.compareTo(o2.label);
            if (rc != 0) {
                return rc;
            }
            return o1.factoryId.compareTo(o2.factoryId);
        }
    };
    private final String factoryId;
    private final String description;
    private final String label;
    private final boolean resolved;
    private final SortedSet<String> requires;
    private final String groupId;
    private final Version version;

    private ChannelAspectInformation(String factoryId) {
        this.factoryId = factoryId;
        this.resolved = false;
        this.groupId = null;
        this.label = null;
        this.description = null;
        this.version = Version.EMPTY;
        this.requires = Collections.emptySortedSet();
    }

    public ChannelAspectInformation(String factoryId, String label, String description, String groupId, SortedSet<String> requires, Version version) {
        this.factoryId = factoryId;
        this.groupId = groupId == null || groupId.isEmpty() ? "other" : groupId;
        this.label = label;
        this.description = description;
        this.requires = requires == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(requires);
        this.version = version;
        this.resolved = true;
    }

    public Version getVersion() {
        return this.version;
    }

    public SortedSet<String> getRequires() {
        return this.requires;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label == null ? this.factoryId : this.label;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public static ChannelAspectInformation unresolved(String factoryId) {
        return new ChannelAspectInformation(factoryId);
    }

    public String toString() {
        return this.factoryId;
    }
}

