/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.maven.ByteArrayAdapter;
import org.eclipse.packagedrone.repo.adapter.maven.MavenInformation;
import org.eclipse.packagedrone.repo.adapter.maven.NodeAdapter;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.scada.utils.str.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChannelData {
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(?<ts>[0-9]{8}-[0-9]{6})-1(?<bn>[0-9]+)");
    private final DirectoryNode root = new DirectoryNode();

    public void add(MavenInformation info, ArtifactInformation art) {
        String[] gn = info.getGroupId().split("\\.");
        DirectoryNode groupNode = this.getGroup(gn);
        DirectoryNode artifactBase = this.addDirNode(groupNode, info.getArtifactId());
        ArtifactMetadataNode mdNode = this.addArtifactMetaDataNode(info, artifactBase);
        DirectoryNode versionNode = this.addDirNode(artifactBase, info.getVersion());
        ChannelData.addNode(versionNode, info.makeName(), new ArtifactNode(art.getId()));
        ChannelData.addCheckSum(versionNode, info.makeName(), art, "md5");
        ChannelData.addCheckSum(versionNode, info.makeName(), art, "sha1");
        mdNode.add(info, art.getCreationTimestamp());
        if (info.isSnapshot()) {
            VersionMetadataNode versionMd = this.addVersionMetaDataNode(info, versionNode);
            versionMd.add(info, art.getCreationTimestamp());
        }
    }

    protected <T extends ContentNode> T addMetaDataNode(MavenInformation info, DirectoryNode base, Class<T> clazz, Supplier<T> supp) {
        Node n = base.getNodes().get("maven-metadata.xml");
        if (n == null) {
            ContentNode result = ChannelData.addNode(base, "maven-metadata.xml", (ContentNode)supp.get());
            ChannelData.addNode(base, "maven-metadata.xml.md5", new ChecksumNode(result, "MD5"));
            ChannelData.addNode(base, "maven-metadata.xml.sha1", new ChecksumNode(result, "SHA1"));
            return (T)result;
        }
        if (clazz.isAssignableFrom(n.getClass())) {
            return (T)((ContentNode)clazz.cast(n));
        }
        throw new IllegalStateException(String.format("Invalid hierarchy. Someone blocked meta data entry: 'maven-metadata.xml'", new Object[0]));
    }

    protected ArtifactMetadataNode addArtifactMetaDataNode(MavenInformation info, DirectoryNode artifactBase) {
        return this.addMetaDataNode(info, artifactBase, ArtifactMetadataNode.class, () -> new ArtifactMetadataNode(info.getGroupId(), info.getArtifactId()));
    }

    protected VersionMetadataNode addVersionMetaDataNode(MavenInformation info, DirectoryNode artifactBase) {
        return this.addMetaDataNode(info, artifactBase, VersionMetadataNode.class, () -> new VersionMetadataNode(info.getGroupId(), info.getArtifactId(), info.getVersion()));
    }

    protected static Document makeMetaData(String groupId, String artifactId, BiConsumer<Document, Element> cons) {
        XmlHelper xml = new XmlHelper();
        Document doc = xml.create();
        Element root = doc.createElement("metadata");
        doc.appendChild(root);
        XmlHelper.addElement((Element)root, (String)"groupId", (Object)groupId);
        XmlHelper.addElement((Element)root, (String)"artifactId", (Object)artifactId);
        Element v = XmlHelper.addElement((Element)root, (String)"versioning");
        cons.accept(doc, v);
        XmlHelper.addElement((Element)v, (String)"lastUpdated", (Object)DATE_FORMAT.format(new Date()));
        return doc;
    }

    public static Document createMetaData(String groupId, String artifactId, String version, List<MavenInformation> infos, Map<MavenInformation, Date> timestamps) {
        return ChannelData.makeMetaData(groupId, artifactId, (doc, v) -> {
            Element ver = doc.createElement("version");
            ver.setTextContent(version);
            v.getParentNode().insertBefore(ver, (org.w3c.dom.Node)v);
            TreeMap<String, LinkedList<MavenInformation>> gi = new TreeMap<String, LinkedList<MavenInformation>>();
            TreeSet<String> snapshots = new TreeSet<String>();
            for (MavenInformation info : infos) {
                if (info.isSnapshot() && info.getSnapshotVersion() == null) continue;
                snapshots.add(info.getSnapshotVersion());
                LinkedList<MavenInformation> list2 = (List)gi.get(info.getSnapshotVersion());
                if (list2 == null) {
                    list2 = new LinkedList<MavenInformation>();
                    gi.put(info.getSnapshotVersion(), list2);
                }
                list2.add(info);
            }
            if (!gi.isEmpty()) {
                Element svs = XmlHelper.addElement((Element)v, (String)"snapshotVersions");
                for (Map.Entry entry : gi.entrySet()) {
                    for (MavenInformation info : (List)entry.getValue()) {
                        Date ts;
                        Element sv = XmlHelper.addElement((Element)svs, (String)"snapshotVersion");
                        XmlHelper.addElement((Element)sv, (String)"extension", (Object)info.getExtension());
                        XmlHelper.addElement((Element)sv, (String)"value", (Object)info.getSnapshotVersion());
                        if (info.getClassifier() != null && !info.getClassifier().isEmpty()) {
                            XmlHelper.addElement((Element)sv, (String)"classifier", (Object)info.getClassifier());
                        }
                        if ((ts = (Date)timestamps.get(info)) == null) continue;
                        XmlHelper.addElement((Element)sv, (String)"updated", (Object)DATE_FORMAT.format(ts));
                    }
                }
                String latest = (String)snapshots.last();
                Matcher m = SNAPSHOT_PATTERN.matcher(latest);
                if (m.matches()) {
                    Element s = XmlHelper.addElementFirst((Element)v, (String)"snapshot");
                    XmlHelper.addElement((Element)s, (String)"timestamp", (Object)m.group("ts"));
                    XmlHelper.addElement((Element)s, (String)"buildNumber", (Object)m.group("bn"));
                }
            }
        });
    }

    public static Document createMetaData(String groupId, String artifactId, List<MavenInformation> infos) {
        return ChannelData.makeMetaData(groupId, artifactId, (doc, v) -> {
            String latestStr;
            List<String> releasesSorted;
            String releaseStr;
            HashSet<String> releases = new HashSet<String>();
            HashSet<String> all = new HashSet<String>();
            for (MavenInformation info : infos) {
                all.add(info.getVersion());
                if (info.isSnapshot()) continue;
                releases.add(info.getVersion());
            }
            List<String> allSorted = ChannelData.sorted(all);
            if (!all.isEmpty()) {
                Element vs = XmlHelper.addElement((Element)v, (String)"versions");
                for (String release : allSorted) {
                    XmlHelper.addElement((Element)vs, (String)"version", (Object)release);
                }
            }
            if (!releases.isEmpty() && (releaseStr = ChannelData.best(releasesSorted = ChannelData.sorted(releases))) != null) {
                Element release = XmlHelper.addElementFirst((Element)v, (String)"release");
                release.setTextContent(releaseStr);
            }
            if ((latestStr = ChannelData.best(allSorted)) != null) {
                Element latest = XmlHelper.addElementFirst((Element)v, (String)"latest");
                latest.setTextContent(latestStr);
            }
        });
    }

    private static List<String> sorted(Set<String> versions) {
        ArrayList<String> list = new ArrayList<String>(versions);
        Collections.sort(list);
        return list;
    }

    private static String best(List<String> versions) {
        if (versions.isEmpty()) {
            return null;
        }
        return versions.get(versions.size() - 1);
    }

    private static void addCheckSum(DirectoryNode versionNode, String name, ArtifactInformation art, String string) {
        String data = (String)art.getMetaData().get(new MetaKey("hasher", string));
        if (data == null) {
            return;
        }
        ChannelData.addNode(versionNode, String.valueOf(name) + "." + string, new DataNode(data, "text/plain"));
    }

    private DirectoryNode getGroup(String[] gn) {
        LinkedList<String> dir = new LinkedList<String>(Arrays.asList(gn));
        DirectoryNode current = this.root;
        while (!dir.isEmpty()) {
            current = this.addDirNode(current, dir.pollFirst());
        }
        return current;
    }

    private static <T extends Node> T addNode(DirectoryNode current, String seg, T node) {
        if (current.nodes.containsKey(seg)) {
            throw new IllegalStateException(String.format("Invalid hierarchy. %s is already used.", seg));
        }
        current.nodes.put(seg, node);
        return node;
    }

    private DirectoryNode addDirNode(DirectoryNode current, String seg) {
        Node g = (Node)current.nodes.get(seg);
        if (g == null) {
            g = new DirectoryNode();
            current.nodes.put(seg, g);
            return (DirectoryNode)g;
        }
        if (g instanceof DirectoryNode) {
            return (DirectoryNode)g;
        }
        throw new IllegalStateException(String.format("Invalid group hierarchy. %s is of type %s.", seg, g.getClass()));
    }

    public Node findNode(Deque<String> segs) {
        Node current = this.root;
        while (!segs.isEmpty()) {
            if (!(current instanceof DirectoryNode)) {
                return null;
            }
            String n = segs.pollFirst();
            Node node = (Node)((DirectoryNode)current).nodes.get(n);
            if (node == null) {
                return null;
            }
            current = node;
        }
        return current;
    }

    public String toJson() {
        Gson gson = ChannelData.makeGson(false);
        return gson.toJson((Object)this);
    }

    public String toString() {
        Gson gson = ChannelData.makeGson(true);
        return gson.toJson((Object)this);
    }

    public static ChannelData fromJson(String json) {
        Gson gson = ChannelData.makeGson(false);
        return (ChannelData)gson.fromJson(json, ChannelData.class);
    }

    public static ChannelData fromReader(Reader reader) {
        Gson gson = ChannelData.makeGson(false);
        return (ChannelData)gson.fromJson(reader, ChannelData.class);
    }

    public static Gson makeGson(boolean pretty) {
        GsonBuilder gb = new GsonBuilder();
        if (pretty) {
            gb.setPrettyPrinting();
        }
        gb.registerTypeAdapter(Node.class, (Object)new NodeAdapter());
        gb.registerTypeAdapter(byte[].class, (Object)new ByteArrayAdapter());
        return gb.create();
    }

    public static class ArtifactMetadataNode
    extends ContentNode {
        private final List<MavenInformation> infos = new LinkedList<MavenInformation>();
        private final String groupId;
        private final String artifactId;

        public ArtifactMetadataNode(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        @Override
        public String getMimeType() {
            return "application/xml";
        }

        @Override
        public byte[] getData() {
            XmlHelper xml = new XmlHelper();
            Document doc = ChannelData.createMetaData(this.groupId, this.artifactId, this.infos);
            try {
                return xml.toData((org.w3c.dom.Node)doc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void add(MavenInformation info, Date date) {
            this.infos.add(info);
        }
    }

    public static class ArtifactNode
    extends Node {
        private final String artifactId;

        public ArtifactNode(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }
    }

    public static class ChecksumNode
    extends ContentNode {
        private final ContentNode node;
        private final String alg;

        public ChecksumNode(ContentNode node, String alg) {
            this.node = node;
            this.alg = alg;
        }

        @Override
        public String getMimeType() {
            return "text/plain";
        }

        @Override
        public byte[] getData() {
            try {
                MessageDigest md = MessageDigest.getInstance(this.alg);
                byte[] result = md.digest(this.node.getData());
                return StringHelper.toHex((byte[])result).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class ContentNode
    extends Node {
        public abstract String getMimeType();

        public abstract byte[] getData();
    }

    public static class DataNode
    extends ContentNode {
        private final byte[] data;
        private final String mimeType;

        public DataNode(byte[] data, String mimeType) {
            this.data = data;
            this.mimeType = mimeType;
        }

        public DataNode(String data, String mimeType) {
            this.data = data.getBytes(StandardCharsets.UTF_8);
            this.mimeType = mimeType;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }
    }

    public static class DirectoryNode
    extends Node {
        private final Map<String, Node> nodes = new HashMap<String, Node>();

        public Map<String, Node> getNodes() {
            return this.nodes;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    }

    public static abstract class Node {
        public boolean isDirectory() {
            return false;
        }
    }

    public static class VersionMetadataNode
    extends ContentNode {
        private final List<MavenInformation> infos = new LinkedList<MavenInformation>();
        private final Map<MavenInformation, Date> timestamps = new HashMap<MavenInformation, Date>();
        private final String groupId;
        private final String artifactId;
        private final String version;

        public VersionMetadataNode(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Override
        public String getMimeType() {
            return "application/xml";
        }

        @Override
        public byte[] getData() {
            XmlHelper xml = new XmlHelper();
            Document doc = ChannelData.createMetaData(this.groupId, this.artifactId, this.version, this.infos, this.timestamps);
            try {
                return xml.toData((org.w3c.dom.Node)doc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void add(MavenInformation info, Date date) {
            this.infos.add(info);
            this.timestamps.put(info, date);
        }
    }
}

