/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2.xml;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.generator.ArtifactGenerator;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.repo.generator.p2.GeneratorController;
import org.eclipse.packagedrone.repo.generator.p2.Helper;
import org.eclipse.packagedrone.repo.generator.p2.Type;
import org.eclipse.packagedrone.repo.generator.p2.xml.CategoryDefinition;
import org.eclipse.packagedrone.repo.generator.p2.xml.CategoryXmlParser;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.web.LinkTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CategoryXmlGenerator
implements ArtifactGenerator {
    public static final String ID = "p2.categoryXml";
    private static final MetaKey MK_OSGI_NAME = new MetaKey("osgi", "name");
    private final XmlHelper xml = new XmlHelper();

    public void generate(GenerationContext context) throws Exception {
        Document doc;
        Throwable throwable = null;
        Object var4_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(context.getFile(), new OpenOption[0]));){
            doc = this.xml.parse((InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        CategoryDefinition def = CategoryXmlParser.parse(doc);
        String baseName = context.getArtifactInformation().getName();
        HashMap<String, Set<ArtifactInformation>> map = new HashMap<String, Set<ArtifactInformation>>();
        for (ArtifactInformation ai : context.getChannelArtifacts()) {
            Set<String> cats;
            String id;
            if (Helper.isBundle(ai.getMetaData())) {
                id = (String)ai.getMetaData().get(MK_OSGI_NAME);
                cats = def.getBundles().get(id);
                if (cats != null) {
                    for (String cat : cats) {
                        this.addMap(map, cat, ai);
                    }
                }
            }
            if (!Helper.isFeature(ai.getMetaData())) continue;
            id = (String)ai.getMetaData().get(MK_OSGI_NAME);
            cats = def.getFeatures().get(id);
            if (cats == null) continue;
            for (String cat : cats) {
                this.addMap(map, cat, ai);
            }
        }
        context.createVirtualArtifact(String.valueOf(baseName) + "-p2metadata.xml", out -> Helper.createFragmentFile(out, units -> {
            for (CategoryDefinition.Category cat : def.getCategories()) {
                Helper.createCategoryUnit(units, cat.getId(), cat.getLabel(), cat.getDescription(), Helper.makeDefaultVersion(), unit -> {
                    Element reqs = XmlHelper.addElement((Element)unit, (String)"requires");
                    HashSet<String> ctx = new HashSet<String>();
                    Set list = (Set)map.get(cat.getId());
                    if (list != null) {
                        for (ArtifactInformation ai : list) {
                            if (Helper.isFeature(ai.getMetaData())) {
                                Helper.addFeatureRequirement(ctx, reqs, ai);
                                continue;
                            }
                            if (!Helper.isBundle(ai.getMetaData())) continue;
                            Helper.addBundleRequirement(ctx, reqs, ai);
                        }
                    }
                    XmlHelper.fixSize((Element)reqs);
                });
            }
        }), null);
    }

    private void addMap(Map<String, Set<ArtifactInformation>> map, String cat, ArtifactInformation ai) {
        Set<ArtifactInformation> list = map.get(cat);
        if (list == null) {
            list = new HashSet<ArtifactInformation>();
            map.put(cat, list);
        }
        list.add(ai);
    }

    public boolean shouldRegenerate(Object event) {
        return Helper.changeOf(event, Type.FEATURE, Type.BUNDLE);
    }

    public LinkTarget getAddTarget() {
        return LinkTarget.createFromController(GeneratorController.class, (String)"createCategoryXml");
    }
}

