/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.store;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStore
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private final Path base;
    private final Path dataPath;
    private Transaction transaction;
    private Set<String> currentIndex;
    private final Path indexPath;

    public BlobStore(Path path) throws IOException {
        this.base = path;
        this.dataPath = this.base.resolve("data").toAbsolutePath();
        this.indexPath = this.base.resolve("index.txt").toAbsolutePath();
        Files.createDirectories(this.dataPath, new FileAttribute[0]);
        Set<String> index = this.loadIndex();
        if (index == null) {
            index = BlobStore.scanIndex(path);
            this.writeIndex(index);
        }
        this.currentIndex = index;
    }

    public static Set<String> scanIndex(Path basePath) throws IOException {
        try {
            return Files.walk(basePath.resolve("data"), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(path -> path.getName(path.getNameCount() - 1).toString()).collect(Collectors.toSet());
        }
        catch (NoSuchFileException noSuchFileException) {
            return Collections.emptySet();
        }
    }

    public boolean handleStream(String id, IOConsumer<InputStream> consumer) throws IOException {
        return this.processStream(id, consumer);
    }

    public long handleCreate(String id, IOConsumer<OutputStream> consumer) throws IOException {
        Path path = this.makeDataPath(id);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CountingOutputStream stream = new CountingOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE_NEW)));){
            consumer.accept((Object)stream);
            return stream.getCount();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void close() {
        if (this.transaction != null) {
            this.handleRollback(this.transaction);
        }
    }

    public boolean stream(String id, IOConsumer<InputStream> consumer) throws IOException {
        if (!this.currentIndex.contains(id)) {
            return false;
        }
        return this.processStream(id, consumer);
    }

    private boolean processStream(String id, IOConsumer<InputStream> consumer) throws IOException {
        block13: {
            Path path = this.makeDataPath(id);
            Throwable throwable = null;
            Object var5_6 = null;
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ));
            try {
                consumer.accept((Object)stream);
                if (stream == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        return false;
                    }
                }
            }
            ((InputStream)stream).close();
        }
        return true;
    }

    public synchronized Transaction start() {
        if (this.transaction == null) {
            this.transaction = new TransactionImpl();
            return this.transaction;
        }
        throw new IllegalStateException("Transaction already in progress");
    }

    protected synchronized void handleCommit(Transaction transaction, Set<String> deleted, Set<String> added) {
        if (this.transaction != transaction) {
            throw new IllegalStateException("Invalid transaction");
        }
        this.transaction = null;
        try {
            HashSet<String> index = new HashSet<String>(this.currentIndex);
            index.removeAll(deleted);
            index.addAll(added);
            this.writeIndex(index);
            for (String id : deleted) {
                Files.deleteIfExists(this.makeDataPath(id));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to commit", e);
        }
    }

    private void writeIndex(Set<String> index) throws IOException {
        Files.write(this.indexPath, index, StandardCharsets.UTF_8, new OpenOption[0]);
        this.currentIndex = index;
    }

    private Set<String> loadIndex() throws IOException {
        try {
            return new HashSet<String>(Files.readAllLines(this.indexPath, StandardCharsets.UTF_8));
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    protected synchronized void handleRollback(Transaction transaction) {
        if (this.transaction != transaction) {
            throw new IllegalStateException("Invalid transaction");
        }
        this.transaction = null;
        try {
            this.vacuum();
        }
        catch (IOException e) {
            logger.warn("Failed to vacuum", (Throwable)e);
        }
    }

    public synchronized void vacuum() throws IOException {
        Set<String> ids = BlobStore.scanIndex(this.base);
        ids.removeAll(this.currentIndex);
        for (String id : ids) {
            Path path = this.makeDataPath(id);
            logger.debug("Vacuuming file: {}", (Object)path);
            Files.deleteIfExists(path);
        }
    }

    private Path makeDataPath(String id) {
        String l1 = id.substring(0, 1);
        String l2 = id.substring(1, 2);
        return this.dataPath.resolve(Paths.get(l1, l2, id));
    }

    public static interface Transaction {
        public boolean delete(String var1) throws IOException;

        default public long create(String id, InputStream source) throws IOException {
            return this.create(id, (IOConsumer<OutputStream>)((IOConsumer)target -> {
                long l = ByteStreams.copy((InputStream)source, (OutputStream)target);
            }));
        }

        public long create(String var1, IOConsumer<OutputStream> var2) throws IOException;

        public boolean stream(String var1, IOConsumer<InputStream> var2) throws IOException;

        public void commit();

        public void rollback();
    }

    public class TransactionImpl
    implements Transaction {
        private boolean done;
        private final Set<String> deleted = new HashSet<String>();
        private final Set<String> added = new HashSet<String>();

        @Override
        public boolean delete(String id) throws IOException {
            this.testDone();
            boolean existed = BlobStore.this.currentIndex.contains(id) || this.added.contains(id);
            this.added.remove(id);
            this.deleted.add(id);
            return existed;
        }

        @Override
        public long create(String id, IOConsumer<OutputStream> consumer) throws IOException {
            this.testDone();
            long size = BlobStore.this.handleCreate(id, consumer);
            this.added.add(id);
            this.deleted.remove(id);
            return size;
        }

        @Override
        public boolean stream(String id, IOConsumer<InputStream> consumer) throws IOException {
            this.testDone();
            if (this.deleted.contains(id)) {
                return false;
            }
            return BlobStore.this.handleStream(id, consumer);
        }

        @Override
        public void commit() {
            this.testDone();
            this.done = true;
            BlobStore.this.handleCommit(this, this.deleted, this.added);
        }

        @Override
        public void rollback() {
            this.testDone();
            this.done = true;
            BlobStore.this.handleRollback(this);
        }

        protected void testDone() {
            if (this.done) {
                throw new IllegalStateException("Transaction already closed");
            }
        }
    }
}

