/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.p2.internal;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.common.p2.P2UnzipAspectFactory;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P2Unzipper
implements Virtualizer {
    private static final Logger logger = LoggerFactory.getLogger(P2Unzipper.class);
    private static final String FILENAME_CONTENT_JAR = "content.jar";
    private static final String FILENAME_ARTIFACTS_JAR = "artifacts.jar";
    private static final String FILENAME_CONTENT_XML = "content.xml";
    private static final String FILENAME_ARTIFACTS_XML = "artifacts.xml";
    private static final String XPATH_EXTRACT_CONTENT = "/repository/units";
    private static final String XPATH_EXTRACT_ARTIFACTS = "/repository/artifacts";
    private static final MetaKey KEY_REUSE_METADATA = new MetaKey("p2.unzip", "reuse-metadata");
    private final XmlToolsFactory xml;

    public P2Unzipper(XmlToolsFactory xml) {
        this.xml = xml;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void virtualize(Virtualizer.Context context) {
        ArtifactInformation ai = context.getArtifactInformation();
        if (!this.isZip(ai)) {
            return;
        }
        boolean reuseMetadata = Boolean.parseBoolean((String)context.getProvidedChannelMetaData().get(KEY_REUSE_METADATA));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(context.getFile().toFile())));){
                while (true) {
                    ZipEntry entry;
                    if ((entry = zis.getNextEntry()) == null) {
                        return;
                    }
                    if (entry.isDirectory()) continue;
                    if (entry.getName().startsWith("features/")) {
                        this.processEntry(context, entry, zis);
                        continue;
                    }
                    if (entry.getName().startsWith("plugins/")) {
                        this.processEntry(context, entry, zis);
                        continue;
                    }
                    if (reuseMetadata && entry.getName().equals(FILENAME_ARTIFACTS_XML)) {
                        try {
                            this.processMetaData(context, zis, FILENAME_ARTIFACTS_XML, XPATH_EXTRACT_ARTIFACTS);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to extract artifacts meta data", (Throwable)e);
                        }
                        continue;
                    }
                    if (reuseMetadata && entry.getName().equals(FILENAME_CONTENT_XML)) {
                        try {
                            this.processMetaData(context, zis, FILENAME_CONTENT_XML, XPATH_EXTRACT_CONTENT);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to extract content meta data", (Throwable)e);
                        }
                        continue;
                    }
                    if (reuseMetadata && entry.getName().equals(FILENAME_ARTIFACTS_JAR)) {
                        try {
                            this.processZippedMetaData(context, zis, FILENAME_ARTIFACTS_XML, XPATH_EXTRACT_ARTIFACTS);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to extract artifacts meta data", (Throwable)e);
                        }
                        continue;
                    }
                    if (!reuseMetadata || !entry.getName().equals(FILENAME_CONTENT_JAR)) continue;
                    try {
                        this.processZippedMetaData(context, zis, FILENAME_CONTENT_XML, XPATH_EXTRACT_CONTENT);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to extract content meta data", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to unzip", (Throwable)e);
            throw new RuntimeException("Failed to unzip", e);
        }
    }

    private void processZippedMetaData(Virtualizer.Context context, ZipInputStream zis, String filename, String xpath) throws Exception {
        ZipEntry entry;
        JarInputStream jin = new JarInputStream((InputStream)zis, false);
        while ((entry = jin.getNextEntry()) != null) {
            if (!entry.getName().equals(filename)) continue;
            this.processMetaData(context, jin, filename, xpath);
        }
    }

    private void processMetaData(Virtualizer.Context context, InputStream in, String filename, String xpath) throws Exception {
        Document doc = this.xml.newDocumentBuilder().parse((InputStream)new CloseShieldInputStream(in));
        XPathExpression path = this.xml.newXPathFactory().newXPath().compile(xpath);
        NodeList result = XmlHelper.executePath((Node)doc, (XPathExpression)path);
        Document fragmentDoc = this.xml.newDocumentBuilder().newDocument();
        Node node = result.item(0);
        node = fragmentDoc.adoptNode(node);
        fragmentDoc.appendChild(node);
        context.createVirtualArtifact(filename, out -> {
            try {
                XmlHelper.write((TransformerFactory)this.xml.newTransformerFactory(), (Node)fragmentDoc, (Result)new StreamResult((OutputStream)out));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }, null);
    }

    private boolean isZip(ArtifactInformation ai) {
        return ai.getName().toLowerCase().endsWith(".zip");
    }

    private void processEntry(Virtualizer.Context context, ZipEntry entry, InputStream in) {
        String[] segs = entry.getName().split("\\/");
        String name = segs[segs.length - 1];
        HashMap<MetaKey, String> metaData = new HashMap<MetaKey, String>(1);
        metaData.put(P2UnzipAspectFactory.MK_FULL_NAME, entry.getName());
        context.createVirtualArtifact(name, out -> {
            long l = ByteStreams.copy((InputStream)in, (OutputStream)out);
        }, metaData);
    }
}

