/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelDetails;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;
import org.eclipse.packagedrone.repo.channel.stats.ChannelStatistics;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public interface ChannelService {
    public static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_\\.]+");

    public Collection<ChannelInformation> list();

    public Optional<ChannelInformation> getState(By var1);

    public ChannelId create(String var1, ChannelDetails var2, Map<MetaKey, String> var3);

    public boolean delete(By var1);

    public <R, T> R accessCall(By var1, Class<T> var2, ChannelOperation<R, T> var3);

    default public <T> void accessRun(By by, Class<T> clazz, ChannelOperationVoid<T> operation) {
        this.accessCall(by, clazz, channel -> {
            operation.process(channel);
            return null;
        });
    }

    default public Optional<Collection<DeployKey>> getChannelDeployKeys(By by) {
        return this.getChannelDeployGroups(by).map(groups -> groups.stream().flatMap(group -> group.getKeys().stream()).collect(Collectors.toList()));
    }

    default public Optional<Set<String>> getChannelDeployKeyStrings(By by) {
        return this.getChannelDeployGroups(by).map(groups -> groups.stream().flatMap(group -> group.getKeys().stream()).map(DeployKey::getKey).collect(Collectors.toSet()));
    }

    public Optional<Collection<DeployGroup>> getChannelDeployGroups(By var1);

    default public boolean streamArtifact(String channelId, String artifactId, ArtifactReceiver receiver) {
        try {
            return this.accessCall(By.id(channelId), ReadableChannel.class, channel -> {
                Optional<ChannelArtifactInformation> artifact = channel.getArtifact(artifactId);
                if (!artifact.isPresent()) {
                    return false;
                }
                return channel.getContext().stream(artifactId, (IOConsumer<InputStream>)((IOConsumer)stream -> receiver.consume((ArtifactInformation)artifact.get(), (InputStream)stream)));
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return false;
        }
    }

    public ChannelStatistics getStatistics();

    public void wipeClean();

    @FunctionalInterface
    public static interface ArtifactReceiver {
        public void consume(ArtifactInformation var1, InputStream var2) throws IOException;
    }

    public static final class By {
        private final Type type;
        private final Object qualifier;

        private By(Type type, Object qualifier) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(qualifier);
            this.type = type;
            this.qualifier = qualifier;
        }

        public Type getType() {
            return this.type;
        }

        public Object getQualifier() {
            return this.qualifier;
        }

        public String toString() {
            return String.format("[By %s = %s]", new Object[]{this.type, this.qualifier});
        }

        public static By id(String channelId) {
            return new By(Type.ID, channelId);
        }

        public static By name(String name) {
            return new By(Type.NAME, name);
        }

        public static By nameOrId(String nameOrId) {
            return new By(Type.COMPOSITE, new By[]{By.id(nameOrId), By.name(nameOrId)});
        }

        public static enum Type {
            ID,
            NAME,
            COMPOSITE;

        }
    }

    @FunctionalInterface
    public static interface ChannelOperation<R, T> {
        public R process(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ChannelOperationVoid<T> {
        public void process(T var1) throws Exception;
    }
}

