/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(JettyWebXmlConfiguration.class);
    public static final String PROPERTY_THIS_WEB_INF_URL = "this.web-inf.url";
    public static final String XML_CONFIGURATION = "org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";

    @Override
    public void configure(final WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        LOG.debug("Configuring web-jetty.xml", new Object[0]);
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty8-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath(JETTY_WEB_XML);
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Configure: " + jetty, new Object[0]);
                }
                Object xml_attr = context.getAttribute(XML_CONFIGURATION);
                context.removeAttribute(XML_CONFIGURATION);
                XmlConfiguration jetty_config = xml_attr instanceof XmlConfiguration ? (XmlConfiguration)xml_attr : new XmlConfiguration(jetty.getURI().toURL());
                this.setupXmlConfiguration(jetty_config, web_inf);
                try {
                    final XmlConfiguration config = jetty_config;
                    context.runWithoutCheckingServerClasses(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            config.configure((Object)context);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying {}", new Object[]{jetty});
                    throw e;
                }
            }
        }
    }

    private void setupXmlConfiguration(XmlConfiguration jetty_config, Resource web_inf) {
        Map props = jetty_config.getProperties();
        props.put(PROPERTY_THIS_WEB_INF_URL, String.valueOf(web_inf.getURL()));
    }
}

