/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.validator.ValidationResult;
import org.eclipse.packagedrone.web.controller.validator.Validator;

public class CompositeValidator
implements Validator {
    private final List<Validator> validators;

    public CompositeValidator(Validator ... validators) {
        this.validators = Arrays.asList(validators);
    }

    public CompositeValidator(List<Validator> validators) {
        this.validators = validators;
    }

    @Override
    public ValidationResult validate(Object target) {
        HashMap<String, List<BindingError>> compositeResult = new HashMap<String, List<BindingError>>();
        HashSet<String> markers = new HashSet<String>();
        for (Validator validator : this.validators) {
            ValidationResult result = validator.validate(target);
            if (result == null) continue;
            markers.addAll(result.getMarkers());
            for (Map.Entry<String, List<BindingError>> entry : result.getErrors().entrySet()) {
                LinkedList pos = (LinkedList)compositeResult.get(entry.getKey());
                if (pos == null) {
                    pos = new LinkedList();
                    compositeResult.put(entry.getKey(), pos);
                }
                pos.addAll(entry.getValue());
            }
        }
        ValidationResult validationResult = new ValidationResult();
        validationResult.setErrors(compositeResult);
        validationResult.setMarkers(markers);
        return validationResult;
    }
}

