/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.ExceptionError;
import org.eclipse.packagedrone.web.controller.binding.SimpleBinding;
import org.eclipse.packagedrone.web.controller.binding.SimpleBindingResult;

public interface Binding {
    public Object getValue();

    public BindingResult getBindingResult();

    default public Object postProcess(Object result) {
        return result;
    }

    public static Binding simpleBinding(Object value) {
        return new SimpleBinding(value);
    }

    public static Binding errorBinding(Throwable error) {
        SimpleBindingResult result = new SimpleBindingResult();
        result.addError(new ExceptionError(error));
        return new SimpleBinding(null, result);
    }

    public static Binding nullBinding() {
        return new Binding(){

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public BindingResult getBindingResult() {
                return null;
            }
        };
    }
}

