/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.profiler;

import java.io.PrintStream;
import java.util.List;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.utils.profiler.ProfileDataHandler;

public class DumpProfileDataHandler
implements ProfileDataHandler {
    public static final ProfileDataHandler INSTANCE = new DumpProfileDataHandler();
    private final PrintStream output = System.out;

    @Override
    public void handle(Profile.DurationEntry entry) {
        this.dumpEntry(entry, 0);
    }

    private void dumpEntry(Profile.DurationEntry entry, int level) {
        this.output.format("%s%s: %s ms%n", DumpProfileDataHandler.makeIndent(level), entry.getOperation(), entry.getDuration().toMillis());
        this.dumpEntries(entry.getEntries(), level + 1);
    }

    private void dumpEntries(List<Profile.DurationEntry> entries, int level) {
        for (Profile.DurationEntry entry : entries) {
            this.dumpEntry(entry, level);
        }
    }

    static String makeIndent(int level) {
        StringBuilder sb = new StringBuilder(level * 2);
        int i = 0;
        while (i < level) {
            sb.append("  ");
            ++i;
        }
        return sb.toString();
    }
}

