/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.page;

import java.util.Collections;
import java.util.List;
import org.eclipse.packagedrone.web.common.page.PaginationResult;

public final class Pagination {
    private Pagination() {
    }

    public static <T> PaginationResult<T> paginate(Integer startPage, int pageSize, Provider<T> provider) {
        int start;
        List<T> data;
        boolean hasNext;
        if (pageSize <= 0) {
            throw new IllegalArgumentException(String.format("Page size must be greater than zero", new Object[0]));
        }
        if (startPage == null || startPage < 0) {
            startPage = 0;
        }
        boolean bl = hasNext = (data = provider.list(start = startPage * pageSize, pageSize + 1)).size() > pageSize;
        if (data.size() > pageSize) {
            data = data.subList(0, pageSize);
        }
        return new PaginationResult<T>(data, start > 0, hasNext, startPage, pageSize);
    }

    public static <T> PaginationResult<T> paginate(Integer startPage, int pageSize, List<T> fullDataSet) {
        return Pagination.paginate(startPage, pageSize, (int start, int length) -> {
            int len = fullDataSet.size();
            if (start > len) {
                return Collections.emptyList();
            }
            return fullDataSet.subList(start, Math.min(start + length, len));
        });
    }

    @FunctionalInterface
    public static interface Provider<T> {
        public List<T> list(int var1, int var2);
    }
}

