/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.web;

import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ViewResolver(value="/WEB-INF/views/info/%s.jsp")
@RequestMapping(value={"/system/info"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class InformationController
implements InterfaceExtender {
    private static final Logger logger = LoggerFactory.getLogger(InformationController.class);
    private StorageManager manager;

    public void setManager(StorageManager manager) {
        this.manager = manager;
    }

    public void unsetManager(StorageManager manager) {
        this.manager = null;
    }

    @RequestMapping
    public ModelAndView view() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Runtime r = Runtime.getRuntime();
        model.put("freeMemory", r.freeMemory());
        model.put("maxMemory", r.maxMemory());
        model.put("totalMemory", r.totalMemory());
        model.put("usedMemory", r.totalMemory() - r.freeMemory());
        model.put("availableProcessors", r.availableProcessors());
        model.put("java", this.makeJavaInformation());
        this.fillFromStorage(model);
        return new ModelAndView("index", model);
    }

    private void fillFromStorage(Map<String, Object> model) {
        if (this.manager != null) {
            Path base = this.manager.getContext().getBasePath();
            try {
                FileStore store = Files.getFileStore(base);
                model.put("storageTotal", store.getTotalSpace());
                model.put("storageFree", store.getUsableSpace());
                model.put("storageUsed", store.getTotalSpace() - store.getUsableSpace());
                model.put("storageName", store.name());
            }
            catch (Exception e) {
                logger.warn("Failed to check storage space", (Throwable)e);
            }
        }
    }

    private Map<String, String> makeJavaInformation() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("Version", System.getProperty("java.version"));
        result.put("Vendor", System.getProperty("java.vendor"));
        result.put("Temp Dir", System.getProperty("java.io.tmpdir"));
        result.put("Home", System.getProperty("java.home"));
        return result;
    }

    @RequestMapping(value={"/gc"})
    public String gc() {
        System.gc();
        return "referer:/system/info";
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("System", Integer.MAX_VALUE, "Information", 1000, LinkTarget.createFromController(InformationController.class, (String)"view"), Modifier.DEFAULT, "cog"));
        }
        return result;
    }
}

