/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.packagedrone.utils.AttributedValue;
import org.eclipse.packagedrone.utils.Headers;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;

public class BundleInformation {
    private final Bundle bundle;
    private final BundleRevision bundleRevision;
    private final URL aboutHtml;
    private final List<LicenseInformation> licenses;
    private final URL licenseTxt;
    private final URL noticeTxt;

    public BundleInformation(Bundle bundle) {
        this.bundle = bundle;
        this.bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.aboutHtml = bundle.getEntry("about.html");
        this.licenseTxt = bundle.getEntry("META-INF/LICENSE.txt");
        this.noticeTxt = bundle.getEntry("META-INF/NOTICE.txt");
        this.licenses = LicenseInformation.parse((String)bundle.getHeaders().get("Bundle-License"));
    }

    public int getState() {
        return this.bundle.getState();
    }

    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public BundleRevision getBundleRevision() {
        return this.bundleRevision;
    }

    public String getName() {
        return (String)this.bundle.getHeaders(null).get("Bundle-Name");
    }

    public boolean isFragment() {
        return (this.bundleRevision.getTypes() & 1) > 0;
    }

    public URL getAboutHtml() {
        return this.aboutHtml;
    }

    public URL getLicenseTxt() {
        return this.licenseTxt;
    }

    public URL getNoticeTxt() {
        return this.noticeTxt;
    }

    public List<LicenseInformation> getLicenses() {
        return this.licenses;
    }

    public static class LicenseInformation {
        private final String license;
        private final URL url;

        public LicenseInformation(String license, URL url) {
            this.license = license;
            this.url = url;
        }

        public String getLicense() {
            return this.license;
        }

        public URL getUrl() {
            return this.url;
        }

        public static List<LicenseInformation> parse(String value) {
            if (value == null) {
                return new LinkedList<LicenseInformation>();
            }
            LinkedList<LicenseInformation> result = new LinkedList<LicenseInformation>();
            List lics = Headers.parseList((String)value);
            for (AttributedValue av : lics) {
                URL url = null;
                String label = null;
                String v = av.getValue();
                try {
                    url = new URL(v);
                    label = "License";
                }
                catch (MalformedURLException malformedURLException) {
                    label = v;
                }
                result.add(new LicenseInformation(label, url));
            }
            return result;
        }
    }
}

