/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.statuscodes;

import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.statuscodes.SeverityLevel;

@Immutable
public class StatusCode {
    private final String moduleCode;
    private final String subModuleCode;
    private final long code;
    private final SeverityLevel severity;

    public StatusCode(String module, String subModule, long code, SeverityLevel severity) {
        this.moduleCode = module;
        this.subModuleCode = subModule;
        this.code = code;
        this.severity = severity;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public String getSubModuleCode() {
        return this.subModuleCode;
    }

    public long getNumberCode() {
        return this.code;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public String toString() {
        String statusCode = String.format("%s-%s-%08X", this.moduleCode, this.subModuleCode, this.code);
        return statusCode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.code ^ this.code >>> 32);
        result = 31 * result + (this.moduleCode == null ? 0 : this.moduleCode.hashCode());
        result = 31 * result + (this.subModuleCode == null ? 0 : this.subModuleCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusCode other = (StatusCode)obj;
        if (this.code != other.code) {
            return false;
        }
        if (this.moduleCode == null ? other.moduleCode != null : !this.moduleCode.equals(other.moduleCode)) {
            return false;
        }
        return !(this.subModuleCode == null ? other.subModuleCode != null : !this.subModuleCode.equals(other.subModuleCode));
    }
}

