/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.eclipse.packagedrone.addon.Addon;
import org.eclipse.packagedrone.addon.AddonInformation;
import org.eclipse.packagedrone.addon.internal.AddonRegistration;
import org.eclipse.packagedrone.utils.Suppressed;

public class AddonImpl
implements Addon {
    private final Path path;
    private final AddonRegistration registration;

    public AddonImpl(AddonRegistration registration) {
        this.path = registration.getPath();
        this.registration = registration;
    }

    @Override
    public String getId() {
        return this.registration.getId();
    }

    @Override
    public void enable() {
        try {
            Files.write(this.enabledFile(), Collections.singletonList(""), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to enable addon", e);
        }
    }

    @Override
    public void disable() {
        try {
            Files.deleteIfExists(this.enabledFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to disable addon", e);
        }
    }

    private Path enabledFile() {
        return this.path.getParent().resolve(this.path.getFileName() + ".enable");
    }

    @Override
    public void uninstall() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Suppressed s = new Suppressed("Failed to uninstall addon", RuntimeException::new);){
            s.run(() -> {
                boolean bl = Files.deleteIfExists(this.path);
            });
            s.run(() -> {
                boolean bl = Files.deleteIfExists(this.enabledFile());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public AddonInformation getInformation() {
        return this.registration.getInformation();
    }
}

