/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.internal.upload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.api.internal.upload.UploadServletV2;
import org.eclipse.packagedrone.repo.api.transfer.TransferArchiveReader;
import org.eclipse.packagedrone.repo.api.upload.ArtifactInformation;
import org.eclipse.packagedrone.repo.api.upload.RejectedArtifact;
import org.eclipse.packagedrone.repo.api.upload.UploadError;
import org.eclipse.packagedrone.repo.api.upload.UploadResult;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.VetoArtifactException;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.utils.PathInformation;
import org.eclipse.scada.utils.ExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServletV3
extends AbstractChannelServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadServletV3.class);
    private static final long serialVersionUID = 1L;
    public static final String BASE_PATH = "/api/v3/upload";

    private Gson createGson() {
        return new GsonBuilder().create();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processError(response, new RequestException(405, "Use POST or PUT requests to upload your content. See the documentation for more information."));
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doStore(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doStore(request, response);
    }

    private void doStore(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Object result = this.processStore(request, response);
            response.setContentType("application/json");
            this.createGson().toJson(result, (Appendable)response.getWriter());
        }
        catch (RequestException e) {
            this.processError(response, e);
        }
    }

    private void processError(HttpServletResponse response, RequestException e) throws IOException {
        response.setStatus(e.getStatusCode());
        response.setContentType("application/json");
        this.createGson().toJson((Object)new UploadError(e.getMessage()), (Appendable)response.getWriter());
    }

    private Object processStore(HttpServletRequest request, HttpServletResponse response) {
        String parentId;
        String channelId;
        String target;
        PathInformation path = new PathInformation(request.getPathInfo());
        String type = path.nextOrThrow(() -> new RequestException("Invalid request path for upload. Missing upload type.")).toLowerCase();
        switch (target = path.nextOrThrow(() -> new RequestException("Invalid request path for upload. Missing target.")).toLowerCase()) {
            case "channel": {
                channelId = path.nextOrThrow(() -> new RequestException("Missing channel ID in request path."));
                parentId = null;
                break;
            }
            case "artifact": {
                channelId = path.nextOrThrow(() -> new RequestException("Missing channel ID in request path."));
                parentId = path.nextOrThrow(() -> new RequestException("Missing parent ID in request path."));
                break;
            }
            default: {
                throw new RequestException(String.format("Unknown upload target type: '%s'", target));
            }
        }
        try {
            switch (type) {
                case "plain": {
                    try {
                        String name = path.getRemainder();
                        return this.processPlain(channelId, parentId, name, request);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new RequestException("Request path is missing artifact name.");
                    }
                }
                case "archive": {
                    if (path.hasNext()) {
                        throw new RequestException("Illegal additional path components found.");
                    }
                    return this.processArchive(channelId, parentId, request);
                }
            }
            throw new RequestException(String.format("Invalid upload type: '%s'", type));
        }
        catch (IOException e) {
            logger.warn("Failed to perform upload", (Throwable)e);
            throw new RequestException(500, "I/O error while uploading");
        }
    }

    private Object processChannel(String channelId, HttpServletRequest request, ChannelService.ChannelOperation<Object, ModifiableChannel> operation) {
        ChannelService.By by = ChannelService.By.nameOrId((String)channelId);
        if (!this.isAuthenticated(by, request)) {
            logger.warn("Request is not authenticated");
            throw this.channelNotFound(channelId);
        }
        ChannelService service = this.getService(request);
        try {
            return service.accessCall(by, ModifiableChannel.class, operation);
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            throw this.channelNotFound(channelId);
        }
        catch (Exception e) {
            throw new RequestException(500, ExceptionHelper.getMessage((Throwable)e));
        }
    }

    private RequestException channelNotFound(String id) {
        return new RequestException(404, String.format("Channel '%s' could not be found", id));
    }

    private Object processPlain(String channelId, String parentId, String artifactName, HttpServletRequest request) throws IOException {
        Map<MetaKey, String> metadata;
        ServletInputStream stream = request.getInputStream();
        try {
            metadata = UploadServletV2.makeMetaData(request);
        }
        catch (IllegalArgumentException e) {
            throw new RequestException(e.getMessage());
        }
        return this.processChannel(channelId, request, (ChannelService.ChannelOperation<Object, ModifiableChannel>)((ChannelService.ChannelOperation)arg_0 -> this.lambda$5(parentId, (InputStream)stream, artifactName, metadata, arg_0)));
    }

    private Object processArchive(String channelId, String rootParentId, HttpServletRequest request) {
        return this.processChannel(channelId, request, (ChannelService.ChannelOperation<Object, ModifiableChannel>)((ChannelService.ChannelOperation)channel -> {
            UploadResult uploadResult = new UploadResult();
            uploadResult.setChannelId(channel.getId().getId());
            TransferArchiveReader reader = new TransferArchiveReader((InputStream)request.getInputStream());
            HashSet ignored = new HashSet();
            reader.process((parentId, artifactName, metadata, stream) -> {
                String id;
                if (ignored.contains(parentId)) {
                    id = UUID.randomUUID().toString();
                    ignored.add(id);
                    RejectedArtifact art = new RejectedArtifact();
                    art.setName(artifactName);
                    art.setReason("Parent artifact was rejected");
                    uploadResult.getRejectedArtifacts().add(art);
                } else {
                    String effectiveParentId = parentId == null ? rootParentId : parentId;
                    try {
                        org.eclipse.packagedrone.repo.channel.ArtifactInformation result = channel.getContext().createArtifact(effectiveParentId, stream, artifactName, metadata);
                        if (result == null) {
                            id = UUID.randomUUID().toString();
                            ignored.add(id);
                        } else {
                            id = result.getId();
                        }
                        this.addResult(uploadResult, artifactName, result);
                    }
                    catch (VetoArtifactException e) {
                        throw new RequestException(409, e.getMessage(), e);
                    }
                }
                return id;
            });
            return uploadResult;
        }));
    }

    private void addResult(UploadResult result, String name, org.eclipse.packagedrone.repo.channel.ArtifactInformation artifact) {
        if (artifact != null) {
            ArtifactInformation art = new ArtifactInformation();
            art.setId(artifact.getId());
            art.setParentId(artifact.getParentId());
            art.setName(artifact.getName());
            art.setSize(artifact.getSize());
            art.setErrors(artifact.getValidationErrorCount());
            art.setWarnings(artifact.getValidationWarningCount());
            result.getCreatedArtifacts().add(art);
        } else {
            RejectedArtifact art = new RejectedArtifact();
            art.setName(name);
            art.setReason("Artifact was rejected by validation");
            result.getRejectedArtifacts().add(art);
        }
    }

    private /* synthetic */ Object lambda$5(String string, InputStream inputStream, String string2, Map map, ModifiableChannel channel) throws Exception {
        org.eclipse.packagedrone.repo.channel.ArtifactInformation result = channel.getContext().createArtifact(string, inputStream, string2, map);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setChannelId(channel.getId().getId());
        this.addResult(uploadResult, string2, result);
        return uploadResult;
    }

    protected static class RequestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final int statusCode;

        public RequestException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public RequestException(int statusCode, String message, Throwable cause) {
            super(message, cause);
            this.statusCode = statusCode;
        }

        public RequestException(String message) {
            this(400, message);
        }

        public RequestException(String message, Throwable cause) {
            this(400, message, cause);
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

