/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PathInformation
implements Iterator<String> {
    private final String path;
    private final int length;
    private int current;

    public PathInformation(String path) {
        Objects.requireNonNull(path);
        this.path = path;
        this.length = path.length();
        this.current = 0;
        this.eatUp();
    }

    @Override
    public boolean hasNext() {
        return this.current < this.length;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        StringBuilder sb = new StringBuilder();
        while (this.current < this.length) {
            char c = this.path.charAt(this.current);
            if (c == '/') {
                this.eatUp();
                break;
            }
            sb.append(c);
            ++this.current;
        }
        return sb.toString();
    }

    public <T extends Throwable> String nextOrThrow(Supplier<T> supplier) throws T {
        try {
            return this.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (Throwable)supplier.get();
        }
    }

    public String nextOrElse(String defaultValue) {
        try {
            return this.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public String nextOrElseGet(Supplier<String> defaultValue) {
        try {
            return this.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue.get();
        }
    }

    private void eatUp() {
        while (this.current < this.length) {
            char c = this.path.charAt(this.current);
            if (c != '/') break;
            ++this.current;
        }
    }

    public String getRemainder() {
        return Arrays.stream(this.getRawRemainder().split("/+")).collect(Collectors.joining("/"));
    }

    public String getRawRemainder() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.path.substring(this.current);
    }
}

