/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import java.io.BufferedInputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.packagedrone.repo.adapter.p2.aspect.P2RepoConstants;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.eclipse.scada.utils.str.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtractorImpl
implements Extractor {
    private final XmlToolsFactory xml;

    public ExtractorImpl(XmlToolsFactory xmlToolsFactory) {
        this.xml = xmlToolsFactory;
    }

    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        DocumentBuilder db = this.xml.newDocumentBuilder();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(context.getPath(), new OpenOption[0]));){
                db.setErrorHandler(null);
                Document doc = db.parse(in);
                if ("artifacts".equals(doc.getDocumentElement().getTagName())) {
                    this.processArtifacts(context, metadata, doc);
                } else if ("units".equals(doc.getDocumentElement().getTagName())) {
                    this.processMetadata(context, metadata, doc);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private void processArtifacts(Extractor.Context context, Map<String, String> metadata, Document doc) throws Exception {
        metadata.put("fragment", "true");
        metadata.put(P2RepoConstants.KEY_FRAGMENT_TYPE.getKey(), "artifacts");
        metadata.put("artifactLabel", "P2 Artifact Information");
        int count = 0;
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<String> sums = new LinkedList<String>();
        Throwable throwable = null;
        Object var8_9 = null;
        try (StringWriter sw = new StringWriter();){
            for (Element ele : XmlHelper.iterElement((Element)doc.getDocumentElement(), (String)"artifact")) {
                if (count > 0) {
                    sw.append(";");
                }
                ++count;
                XmlHelper.write((TransformerFactory)this.xml.newTransformerFactory(), (Node)ele, (Result)new StreamResult(sw), t -> t.setOutputProperty("omit-xml-declaration", "yes"));
                keys.add(ExtractorImpl.makeKey(ele));
                String md5 = "";
                for (Element props : XmlHelper.iterElement((Element)ele, (String)"properties")) {
                    for (Element p : XmlHelper.iterElement((Element)props, (String)"property")) {
                        if (!"download.md5".equals(p.getAttribute("name"))) continue;
                        md5 = p.getAttribute("value");
                    }
                }
                sums.add(md5);
            }
            metadata.put(P2RepoConstants.KEY_FRAGMENT_DATA.getKey(), sw.toString());
            metadata.put(P2RepoConstants.KEY_FRAGMENT_KEYS.getKey(), StringHelper.join(keys, (String)";"));
            metadata.put(P2RepoConstants.KEY_FRAGMENT_MD5.getKey(), StringHelper.join(sums, (String)";"));
            metadata.put(P2RepoConstants.KEY_FRAGMENT_COUNT.getKey(), Integer.toString(count));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void processMetadata(Extractor.Context context, Map<String, String> metadata, Document doc) throws Exception {
        metadata.put("fragment", "true");
        metadata.put(P2RepoConstants.KEY_FRAGMENT_TYPE.getKey(), "metadata");
        metadata.put("artifactLabel", "P2 Meta Data Fragment");
        int count = 0;
        Throwable throwable = null;
        Object var6_7 = null;
        try (StringWriter sw = new StringWriter();){
            for (Element ele : XmlHelper.iterElement((Element)doc.getDocumentElement(), (String)"unit")) {
                ++count;
                XmlHelper.write((TransformerFactory)this.xml.newTransformerFactory(), (Node)ele, (Result)new StreamResult(sw), t -> t.setOutputProperty("omit-xml-declaration", "yes"));
            }
            metadata.put(P2RepoConstants.KEY_FRAGMENT_DATA.getKey(), sw.toString());
            metadata.put(P2RepoConstants.KEY_FRAGMENT_COUNT.getKey(), Integer.toString(count));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String makeKey(Element ele) {
        String classifier = ele.getAttribute("classifier");
        String id = ele.getAttribute("id");
        String version = ele.getAttribute("version");
        return String.format("%s::%s::%s", classifier, id, version);
    }
}

