/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.apm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobQueue {
    private static final Logger logger = LoggerFactory.getLogger(JobQueue.class);
    private static AtomicLong GLOBAL_COUNTER = new AtomicLong();
    private static AtomicLong localCounter = new AtomicLong();
    private ExecutorService executor;

    public void start() {
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryImpl(GLOBAL_COUNTER.incrementAndGet()));
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void push(Runnable task) {
        logger.debug("Pushing task: {}", (Object)task);
        this.executor.execute(task);
    }

    public class ThreadFactoryImpl
    implements ThreadFactory {
        private final long globalCounter;

        public ThreadFactoryImpl(long globalCounter) {
            this.globalCounter = globalCounter;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.makeName());
            return t;
        }

        private String makeName() {
            return String.format("job-processor/%s/%s", this.globalCounter, localCounter.incrementAndGet());
        }
    }
}

