/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.transfer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessor;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;

public class TriggerExport {
    private final List<TriggerEntry> entries = new LinkedList<TriggerEntry>();

    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public String toJson() {
        return TriggerExport.createGson().toJson((Object)this);
    }

    public static TriggerExport fromJson(String json) {
        return (TriggerExport)TriggerExport.createGson().fromJson(json, TriggerExport.class);
    }

    public static TriggerExport buildFrom(TriggeredChannel channel) {
        TriggerExport result = new TriggerExport();
        for (TriggerHandle handle : channel.listTriggers()) {
            String id = handle.getId();
            TriggerEntry entry = new TriggerEntry();
            entry.setId(id);
            entry.setProcessors(handle.getProcessors().stream().map(TriggerExport::exportProcessor).collect(Collectors.toCollection(ArrayList::new)));
            handle.getConfiguration().ifPresent(cfg -> {
                entry.setFactoryId(cfg.getTriggerFactoryId());
                entry.setId(null);
                entry.setConfiguration(cfg.getConfiguration());
            });
            if (entry.getFactoryId() == null && entry.getProcessors().isEmpty()) continue;
            result.entries.add(entry);
        }
        return result;
    }

    private static ProcessorEntry exportProcessor(TriggerProcessor processor) {
        ProcessorEntry entry = new ProcessorEntry();
        entry.setFactoryId(processor.getConfiguration().getFactoryId());
        entry.setConfiguration(processor.getConfiguration().getConfiguration());
        return entry;
    }

    public void apply(TriggeredChannel channel) {
        for (TriggerEntry entry : this.entries) {
            String triggerId = entry.getFactoryId() != null ? channel.addConfiguredTrigger(entry.getFactoryId(), entry.getConfiguration()).getId() : entry.getId();
            for (ProcessorEntry processor : entry.getProcessors()) {
                channel.addProcessor(triggerId, processor.getFactoryId(), processor.getConfiguration());
            }
        }
    }

    public static class ProcessorEntry {
        private String factoryId;
        private String configuration;

        public String getFactoryId() {
            return this.factoryId;
        }

        public void setFactoryId(String factoryId) {
            this.factoryId = factoryId;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(String configuration) {
            this.configuration = configuration;
        }
    }

    public static class TriggerEntry {
        private String id;
        private String factoryId;
        private String configuration;
        private List<ProcessorEntry> processors;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFactoryId() {
            return this.factoryId;
        }

        public void setFactoryId(String factoryId) {
            this.factoryId = factoryId;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public List<ProcessorEntry> getProcessors() {
            return this.processors;
        }

        public void setProcessors(List<ProcessorEntry> processors) {
            this.processors = processors;
        }
    }
}

