/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.sec.web.captcha.CaptchaResult;
import org.eclipse.packagedrone.sec.web.captcha.CaptchaService;
import org.eclipse.packagedrone.sec.web.ui.internal.Activator;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.web.controller.AbstractControllerBinder;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.MessageBindingError;
import org.eclipse.packagedrone.web.controller.binding.SimpleBinding;
import org.eclipse.packagedrone.web.controller.binding.SimpleBindingResult;

public class CaptchaBinder
extends AbstractControllerBinder {
    private HttpServletRequest request;

    @Binder.Initializer
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected CaptchaService getService() {
        return Activator.getCaptchaService();
    }

    public Binding performBind(BindTarget target, ConverterManager converter, BindingManager bindingManager) {
        Class type = target.getType();
        if (!type.isAssignableFrom(CaptchaResult.class)) {
            return null;
        }
        CaptchaService service = this.getService();
        if (service == null) {
            return new SimpleBinding((Object)CaptchaResult.OK);
        }
        CaptchaResult result = this.getService().checkCaptcha(this.request);
        SimpleBindingResult bindingResult = new SimpleBindingResult();
        if (!result.isSuccess()) {
            List errors = result.getErrorMessages().stream().map(MessageBindingError::new).collect(Collectors.toList());
            bindingResult.addErrors(this.getName(), errors);
        }
        return new SimpleBinding((Object)result, (BindingResult)bindingResult);
    }

    private String getName() {
        return this.getParameters().getOrDefault("name", "captcha");
    }
}

