/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.animation.effects;

import org.eclipse.nebula.cwt.animation.effects.AbstractEffect;
import org.eclipse.nebula.cwt.animation.movement.IMovement;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public class MoveScrollBar
extends AbstractEffect {
    int start;
    int end;
    int step;
    int current;
    ScrollBar scrollBar = null;

    public MoveScrollBar(ScrollBar scrollBar, int start, int end, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.start = start;
        this.end = end;
        this.step = end - start;
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
        this.scrollBar = scrollBar;
        this.current = start;
    }

    @Override
    public void applyEffect(long currentTime) {
        this.current = (int)((double)this.start + (double)this.step * this.easingFunction.getValue((int)currentTime));
        if (!this.scrollBar.isDisposed()) {
            this.scrollBar.setSelection(this.current);
            Event event = new Event();
            event.detail = this.step < 0 ? 0x1000005 : 0x1000006;
            event.data = this;
            event.display = this.scrollBar.getDisplay();
            event.widget = this.scrollBar;
            event.doit = true;
            this.scrollBar.notifyListeners(13, event);
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getCurrent() {
        return this.current;
    }
}

