/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDragAdapter
extends DragSourceAdapter {
    private final INavigatorContentService contentService;
    private final ISelectionProvider provider;
    private CommonDragAdapterAssistant setDataAssistant;
    private List<CommonDragAdapterAssistant> assistantsToUse;

    public CommonDragAdapter(INavigatorContentService aContentService, ISelectionProvider aProvider) {
        this.contentService = aContentService;
        this.provider = aProvider;
        this.assistantsToUse = new ArrayList<CommonDragAdapterAssistant>();
    }

    public Transfer[] getSupportedDragTransfers() {
        CommonDragAdapterAssistant[] assistants = this.contentService.getDnDService().getCommonDragAssistants();
        LinkedHashSet<Object> supportedTypes = new LinkedHashSet<Object>();
        supportedTypes.add(PluginTransfer.getInstance());
        supportedTypes.add(LocalSelectionTransfer.getTransfer());
        Transfer[] transferTypes = null;
        CommonDragAdapterAssistant[] commonDragAdapterAssistantArray = assistants;
        int n = assistants.length;
        int n2 = 0;
        while (n2 < n) {
            CommonDragAdapterAssistant assistant = commonDragAdapterAssistantArray[n2];
            Transfer[] transferArray = transferTypes = assistant.getSupportedTransferTypes();
            int n3 = transferTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                Transfer transferType = transferArray[n4];
                if (transferType != null) {
                    supportedTypes.add(transferType);
                }
                ++n4;
            }
            ++n2;
        }
        return supportedTypes.toArray(new Transfer[supportedTypes.size()]);
    }

    public void dragStart(final DragSourceEvent event) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragStart (begin): " + event);
        }
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                Control control;
                DragSource dragSource = (DragSource)event.widget;
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDragAdapter.dragStart source: " + dragSource);
                }
                if ((control = dragSource.getControl()) == control.getDisplay().getFocusControl()) {
                    ISelection selection = CommonDragAdapter.this.provider.getSelection();
                    CommonDragAdapter.this.assistantsToUse.clear();
                    if (!selection.isEmpty()) {
                        LocalSelectionTransfer.getTransfer().setSelection(selection);
                        boolean doIt = false;
                        INavigatorDnDService dndService = CommonDragAdapter.this.contentService.getDnDService();
                        CommonDragAdapterAssistant[] assistants = dndService.getCommonDragAssistants();
                        if (assistants.length == 0) {
                            doIt = true;
                        }
                        CommonDragAdapterAssistant[] commonDragAdapterAssistantArray = assistants;
                        int n = assistants.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CommonDragAdapterAssistant assistant = commonDragAdapterAssistantArray[n2];
                            if (Policy.DEBUG_DND) {
                                System.out.println("CommonDragAdapter.dragStart assistant: " + assistant);
                            }
                            event.doit = true;
                            assistant.dragStart(event, (IStructuredSelection)selection);
                            doIt |= event.doit;
                            if (event.doit) {
                                if (Policy.DEBUG_DND) {
                                    System.out.println("CommonDragAdapter.dragStart assistant - event.doit == true");
                                }
                                CommonDragAdapter.this.assistantsToUse.add(assistant);
                            }
                            ++n2;
                        }
                        event.doit = doIt;
                    } else {
                        event.doit = false;
                    }
                } else {
                    event.doit = false;
                }
            }
        });
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragStart (end): doit=" + event.doit);
        }
    }

    public void dragSetData(final DragSourceEvent event) {
        final ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragSetData: event" + event + " selection=" + selection);
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = selection;
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData set LocalSelectionTransfer: " + event.data);
            }
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData set PluginTransfer: " + event.data);
            }
        } else if (selection instanceof IStructuredSelection) {
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData looking for assistants");
            }
            for (final CommonDragAdapterAssistant assistant : this.assistantsToUse) {
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDragAdapter.dragSetData assistant: " + assistant);
                }
                Transfer[] supportedTransferTypes = assistant.getSupportedTransferTypes();
                final boolean[] getOut = new boolean[1];
                Transfer[] transferArray = supportedTransferTypes;
                int n = supportedTransferTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Transfer supportedTransferType = transferArray[n2];
                    if (supportedTransferType.isSupportedType(event.dataType)) {
                        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                            @Override
                            public void run() throws Exception {
                                if (Policy.DEBUG_DND) {
                                    System.out.println("CommonDragAdapter.dragSetData supported xfer type");
                                }
                                if (assistant.setDragData(event, (IStructuredSelection)selection)) {
                                    if (Policy.DEBUG_DND) {
                                        System.out.println("CommonDragAdapter.dragSetData set data " + event.data);
                                    }
                                    CommonDragAdapter.this.setDataAssistant = assistant;
                                    getOut[0] = true;
                                }
                            }
                        });
                        if (getOut[0]) {
                            return;
                        }
                    }
                    ++n2;
                }
            }
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData FAILED no assistant handled it");
            }
            event.doit = false;
        } else {
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData FAILED can't identify transfer type");
            }
            event.doit = false;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragFinished(): " + event);
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (event.doit && selection instanceof IStructuredSelection && this.setDataAssistant != null) {
            this.setDataAssistant.dragFinished(event, (IStructuredSelection)selection);
        }
        this.setDataAssistant = null;
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }
}

