/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativePackageEntry;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class CheckAndPromptNativePackage
extends ProvisioningAction {
    public static final String ID = "checkAndPromptNativePackage";
    private static final String IS_INSTALLED = "isInstalled.sh";
    private static final String IS_RUNNING = "isRunning.sh";
    private static final String SHELL = "/bin/sh";

    public IStatus execute(Map<String, Object> parameters) {
        String distro = (String)parameters.get("distro");
        String packageName = (String)parameters.get("package");
        String packageVersion = (String)parameters.get("version");
        String versionComparator = (String)parameters.get("comparator");
        if (distro == null || packageName == null || versionComparator != null && packageVersion == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", Messages.Incorrect_Command);
        }
        if (!this.runningDistro(distro = distro.toLowerCase())) {
            return Status.OK_STATUS;
        }
        File scriptToExecute = NativeTouchpoint.getFileFromBundle(distro, IS_INSTALLED);
        if (scriptToExecute == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Find_status, (Object)distro));
        }
        try {
            ArrayList<String> cmd = new ArrayList<String>(4);
            cmd.add(SHELL);
            cmd.add(scriptToExecute.getAbsolutePath());
            cmd.add(packageName);
            if (packageVersion != null) {
                if (versionComparator == null) {
                    versionComparator = "ge";
                }
                cmd.add(versionComparator);
                cmd.add(packageVersion);
            }
            int exitValue = new ProcessBuilder(cmd).start().waitFor();
            switch (exitValue) {
                case 0: {
                    return Status.OK_STATUS;
                }
                case 1: 
                case 2: {
                    ((NativeTouchpoint)this.getTouchpoint()).addPackageToInstall(new NativePackageEntry(packageName, packageVersion, versionComparator));
                    ((NativeTouchpoint)this.getTouchpoint()).setDistro(distro);
                    return Status.OK_STATUS;
                }
            }
        }
        catch (IOException iOException) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Check_Package, (Object[])new String[]{packageName, packageVersion, distro}));
        }
        catch (InterruptedException interruptedException) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Check_Package, (Object[])new String[]{packageName, packageVersion, distro}));
        }
        return Status.OK_STATUS;
    }

    protected boolean runningDistro(String distro) {
        File scriptToExecute;
        block4: {
            scriptToExecute = NativeTouchpoint.getFileFromBundle(distro, IS_RUNNING);
            if (scriptToExecute != null) break block4;
            return false;
        }
        try {
            ArrayList<String> cmd = new ArrayList<String>(4);
            cmd.add(SHELL);
            cmd.add(scriptToExecute.getAbsolutePath());
            int exitValue = new ProcessBuilder(cmd).start().waitFor();
            return exitValue == 0;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        return null;
    }
}

