/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.oomph.projectconfig.InclusionPredicate;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.provider.ExclusionPredicateItemProvider;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;

public class InclusionPredicateItemProvider
extends PredicateItemProvider {
    public InclusionPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIncludedPreferenceProfilesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIncludedPreferenceProfilesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_InclusionPredicate_includedPreferenceProfiles_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_InclusionPredicate_includedPreferenceProfiles_feature", "_UI_InclusionPredicate_type"), (EStructuralFeature)ProjectConfigPackage.Literals.INCLUSION_PREDICATE__INCLUDED_PREFERENCE_PROFILES, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection result = super.getChoiceOfValues(object);
                ExclusionPredicateItemProvider.filterCircularPreferenceProfiles((EObject)object, result);
                return result;
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/InclusionPredicate"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        InclusionPredicate inclusionPredicate = (InclusionPredicate)object;
        StringBuilder result = new StringBuilder();
        for (PreferenceProfile preferenceProfile : inclusionPredicate.getIncludedPreferenceProfiles()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(preferenceProfile.getName());
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(InclusionPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ProjectConfigEditPlugin.INSTANCE;
    }
}

