/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEKeyParameters;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEParameters;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEPrivateKeyParameters;

public class SIKEKEMExtractor
implements EncapsulatedSecretExtractor {
    private SIKEEngine engine;
    private SIKEKeyParameters key;

    public SIKEKEMExtractor(SIKEPrivateKeyParameters sIKEPrivateKeyParameters) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKEM", 0, sIKEPrivateKeyParameters, CryptoServicePurpose.DECRYPTION));
        this.key = sIKEPrivateKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(SIKEParameters sIKEParameters) {
        this.engine = sIKEParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        return this.extractSecret(byArray, this.engine.getDefaultSessionKeySize());
    }

    public byte[] extractSecret(byte[] byArray, int n) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        byte[] byArray2 = new byte[n / 8];
        this.engine.crypto_kem_dec(byArray2, byArray, ((SIKEPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

